/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.legacy;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.siams.cv.monitor.model.legacy.ProjectSphKind;
import com.siams.cv.monitor.model.legacy.ProjectViewer;
import com.siams.cv.monitor.model.viewer.SphViewerModel;
import com.siams.cv.monitor.model.viewer.ViewerModel;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProjectSphViewer
extends ProjectViewer {
    @JsonProperty(value="scale")
    private Double scale = 20.0;
    @JsonProperty(value="x_rotate_degree")
    private Double xRotateDegree = 0.0;
    @JsonProperty(value="y_rotate_degree")
    private Double yRotateDegree = 0.0;
    @JsonProperty(value="z_rotate_degree")
    private Double zRotateDegree = 0.0;
    @JsonProperty(value="x_translate")
    private Integer xTranslate = 0;
    @JsonProperty(value="y_translate")
    private Integer yTranslate = 0;
    @JsonProperty(value="z_section")
    private Double zSection = 1.0;
    @JsonProperty(value="z_section_enabled")
    private Boolean zSectionEnabled = true;
    @JsonProperty(value="upward_axis_y")
    private Boolean upwardAxisY = true;
    @JsonProperty(value="splitter_position")
    private Double splitterPosition = 0.8;
    @JsonProperty(value="kind_set")
    private Set<ProjectSphKind> sphKindSet = new HashSet<ProjectSphKind>();

    public Double getScale() {
        return this.scale;
    }

    public void setScale(Double scale) {
        this.scale = scale;
    }

    public Double getXRotateDegree() {
        return this.xRotateDegree;
    }

    public void setXRotateDegree(Double xRotateDegree) {
        this.xRotateDegree = xRotateDegree;
    }

    public Double getYRotateDegree() {
        return this.yRotateDegree;
    }

    public void setYRotateDegree(Double yRotateDegree) {
        this.yRotateDegree = yRotateDegree;
    }

    public Double getZRotateDegree() {
        return this.zRotateDegree;
    }

    public void setZRotateDegree(Double zRotateDegree) {
        this.zRotateDegree = zRotateDegree;
    }

    public Integer getXTranslate() {
        return this.xTranslate;
    }

    public void setXTranslate(Integer xTranslate) {
        this.xTranslate = xTranslate;
    }

    public Integer getYTranslate() {
        return this.yTranslate;
    }

    public void setYTranslate(Integer yTranslate) {
        this.yTranslate = yTranslate;
    }

    public Double getZSection() {
        return this.zSection;
    }

    public void setZSection(Double zSection) {
        this.zSection = zSection;
    }

    public Boolean getZSectionEnabled() {
        return this.zSectionEnabled;
    }

    public void setZSectionEnabled(Boolean zSectionEnabled) {
        this.zSectionEnabled = zSectionEnabled;
    }

    public Boolean getUpwardAxisY() {
        return this.upwardAxisY;
    }

    public void setUpwardAxisY(Boolean upwardAxisY) {
        this.upwardAxisY = upwardAxisY;
    }

    public Double getSplitterPosition() {
        return this.splitterPosition;
    }

    public void setSplitterPosition(Double hSplitPaneControl) {
        this.splitterPosition = hSplitPaneControl;
    }

    public Set<ProjectSphKind> getSphKindSet() {
        return this.sphKindSet;
    }

    public void setSphKindSet(Set<ProjectSphKind> sphKindSet) {
        this.sphKindSet = sphKindSet;
    }

    public Optional<ProjectSphKind> findSphKind(Long id) {
        return this.sphKindSet.stream().filter(kind -> kind.getId().equals(id)).findFirst();
    }

    public boolean addSphKind(ProjectSphKind projectSphKind) {
        return this.sphKindSet.add(projectSphKind);
    }

    public SphViewerModel convertToModel() {
        SphViewerModel model = new SphViewerModel();
        this.initializeViewerModelBasics((ViewerModel)model);
        model.setScale(this.scale);
        model.setSplitterPosition(this.splitterPosition);
        model.setUpwardAxisY(this.upwardAxisY);
        model.setXTranslate(this.xTranslate);
        model.setYTranslate(this.yTranslate);
        model.setZSectionEnabled(this.zSectionEnabled);
        model.setZSection(this.zSection);
        model.setXRotateDegree(this.xRotateDegree);
        model.setYRotateDegree(this.yRotateDegree);
        model.setZRotateDegree(this.zRotateDegree);
        Set kindModels = this.sphKindSet.stream().map(ProjectSphKind::convertToNodeModel).collect(Collectors.toSet());
        model.setSphKindSet(kindModels);
        return model;
    }
}

