/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.legacy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.siams.collection.CollectionsUtils;
import com.siams.cv.monitor.model.legacy.ProjectViewer;
import com.siams.cv.monitor.model.viewer.CompareViewerModel;
import com.siams.cv.monitor.model.viewer.ViewerModel;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProjectCompareViewer
extends ProjectViewer {
    public static String id = "ProjectCompareViewer";
    @JsonProperty(value="storage_key")
    private String key = "";
    @JsonProperty(value="viewers")
    private Set<ProjectViewer> viewers = new LinkedHashSet<ProjectViewer>();
    @JsonProperty(value="title")
    private String title = "";
    @JsonProperty(value="order")
    private Integer order = -1;
    @JsonProperty(value="splitter_position")
    private Double splitterPosition = 0.8;
    @JsonProperty(value="update_instantly")
    protected Boolean updateInstantly = false;

    @JsonCreator
    public ProjectCompareViewer() {
    }

    @JsonGetter(value="viewers")
    public Set<ProjectViewer> getProjectViewers() {
        return this.viewers;
    }

    @JsonSetter(value="viewers")
    public void setProjectViewers(ArrayList<ProjectViewer> viewers) {
        this.viewers.addAll(viewers);
    }

    @JsonGetter(value="storage_key")
    public String getStorageKey() {
        return this.key;
    }

    @JsonSetter(value="storage_key")
    public void setStorageKey(String key) {
        this.key = key;
    }

    @Override
    @JsonGetter(value="title")
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonSetter(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonGetter(value="order")
    public Integer getOrder() {
        return this.order;
    }

    @JsonSetter(value="order")
    public void setOrder(Integer order) {
        this.order = order;
    }

    @JsonGetter(value="splitter_position")
    public Double getSplitterPosition() {
        return this.splitterPosition;
    }

    @JsonSetter(value="splitter_position")
    public void setSplitterPosition(Double splitterPosition) {
        this.splitterPosition = splitterPosition;
    }

    @JsonGetter(value="update_instantly")
    public Boolean getUpdateInstantly() {
        return this.updateInstantly;
    }

    @JsonSetter(value="update_instantly")
    public void setUpdateInstantly(Boolean updateInstantly) {
        this.updateInstantly = updateInstantly;
    }

    @JsonIgnore
    public <T extends ProjectViewer> T createAndAddViewer(UUID id, Class<T> clazz) {
        ProjectViewer projectViewer = null;
        try {
            projectViewer = (ProjectViewer)clazz.newInstance();
            projectViewer.setUuid(id);
            this.addProjectViewer(projectViewer);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return (T)projectViewer;
    }

    @JsonIgnore
    public void addProjectViewer(ProjectViewer viewer) {
        this.viewers.add(viewer);
    }

    @JsonIgnore
    public void clearProjectViewers() {
        this.viewers.clear();
    }

    @JsonIgnore
    public Optional<ProjectViewer> removeProjectViewerById(UUID uuid) {
        return CollectionsUtils.removeFirst(this.viewers, viewer -> viewer.getUuid().equals(uuid), ProjectViewer.class);
    }

    public <T extends ProjectViewer> Optional<T> findProjectViewer(UUID uuid, Class<T> clazz) {
        return CollectionsUtils.findFirst(this.viewers, viewer -> viewer.getUuid().equals(uuid), clazz);
    }

    public CompareViewerModel convertToModel() {
        CompareViewerModel model = new CompareViewerModel();
        this.initializeViewerModelBasics((ViewerModel)model);
        model.setStorageKey(this.key);
        model.setTitle(this.title);
        model.setOrder(this.order);
        model.setSplitterPosition(this.splitterPosition);
        model.setUpdateInstantly(this.updateInstantly);
        model.setViewerModels(this.viewers.stream().map(ProjectViewer::convertToModel).collect(Collectors.toList()));
        return model;
    }

    @Override
    public void release() {
        this.uuid = new UUID(0L, 0L);
        this.viewers.clear();
    }
}

