/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.app;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.message.NodeRemoved;
import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.Model;
import com.siams.cv.monitor.model.app.Root;
import com.siams.cv.monitor.model.app.StareProject;
import com.siams.cv.monitor.model.node.UIPortModel;
import com.siams.cv.monitor.plugin.PluginModel;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.cv.monitor.ui.factory.UIPort;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class Project
implements Deletable,
IIdentifiable {
    private String url = "";
    private File currentWorkingDirectory = null;
    private File projectFile = null;
    private boolean loadedFromFile = false;
    private StareProject stareProject = new StareProject();

    Project() {
        this.subscribe();
    }

    public File getCurrentWorkingDirectory() {
        return this.currentWorkingDirectory;
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    private String convertToForwardSlash(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
        this.stareProject.setCaption(projectFile != null ? this.convertToForwardSlash(projectFile.getAbsolutePath()) : "[untitled]");
        this.stareProject.setVirginProject(projectFile == null);
        if (projectFile == null) {
            this.loadedFromFile = false;
        }
    }

    public boolean isLoadedFromFile() {
        return this.loadedFromFile;
    }

    public void setLoadedFromFile(boolean loadedFromFile) {
        this.loadedFromFile = loadedFromFile;
    }

    @Subscribe
    public void onNodeRemoved(NodeRemoved event) {
        this.stareProject.removeModel(event.getUuid());
    }

    public void addModel(Model stareNode) {
        this.stareProject.addModel(stareNode);
    }

    public Optional<Model> removeModel(Model model) {
        return this.stareProject.removeModel(model);
    }

    public Optional<Model> removeModelById(UUID id) {
        return this.stareProject.removeModel(id);
    }

    public Optional<Model> removeModelByPredicate(Predicate<Model> predicate) {
        return this.stareProject.removeModel(predicate);
    }

    public <V extends Model> Optional<V> removeModelByPredicate(Class<V> clazz, Predicate<V> predicate) {
        return this.stareProject.removeModel(clazz, predicate);
    }

    public List<Model> removeAllModelByPredicate(Predicate<Model> predicate) {
        return this.stareProject.removeModels(predicate);
    }

    public Optional<Model> findModelByUuid(UUID uuid) {
        return this.stareProject.findModel(uuid);
    }

    public Optional<Model> findModelByPredicate(Predicate<Model> predicate) {
        return this.stareProject.findModel(predicate);
    }

    public <V extends Model> Optional<V> findModel(IIdentifiable iid, Class<V> clazz) {
        return this.findModel(iid.getUuid(), clazz);
    }

    public <V extends Model> Optional<V> findModel(Class<V> clazz, Predicate<V> predicate) {
        return this.stareProject.findModel(clazz, predicate);
    }

    public <V extends Model> Optional<V> findModel(UUID uuid, Class<V> clazz) {
        return this.stareProject.findModel(uuid, clazz);
    }

    public <V extends Model> List<V> findAllModels(Class<V> clazz) {
        return this.stareProject.findModels(clazz);
    }

    public <V extends Model> List<V> findAllModelsByPredicate(Class<V> clazz, Predicate<V> predicate) {
        return this.stareProject.findModels(clazz, predicate);
    }

    public Optional<UIPortModel> findPortModel(UIPort port) {
        Objects.requireNonNull(port, "Port required");
        return this.findModel(port, UIPortModel.class);
    }

    public Optional<UIPortModel> findPortModel(IIdentifiable port) {
        Objects.requireNonNull(port, "Port required");
        return this.findModel(port, UIPortModel.class);
    }

    public <T extends PluginModel> Optional<T> findPlugin(String id, Class<T> clazz) {
        Objects.requireNonNull(id, "Required id");
        return this.stareProject.findPlugin(id, clazz);
    }

    public boolean hasPlugin(String id) {
        Objects.requireNonNull(id, "Required id");
        return this.stareProject.hasPlugin(id);
    }

    public void addPlugin(PluginModel plugin) {
        this.stareProject.addPlugin(plugin);
    }

    @Override
    public void release() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        this.stareProject.release();
    }

    void setVersion(String version) {
        this.stareProject.setVersion(version);
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCaption() {
        if (App.getInstance().getProgramArguments().isDebug()) {
            return this.stareProject.getCaption() + " " + this.url;
        }
        return this.stareProject.getCaption();
    }

    public void setStareProject(StareProject stareProject) {
        this.stareProject = Objects.requireNonNull(stareProject);
    }

    public StareProject getStareProject() {
        return this.stareProject;
    }

    public List<Model> getModels() {
        return this.stareProject.getModels();
    }

    public Root getRoot() {
        return this.stareProject.getRoot();
    }

    public void setModels(List<Model> models) {
        this.stareProject.setModels(models);
    }

    public void setPlugins(List<PluginModel> plugins) {
        this.stareProject.setPlugins(plugins);
    }

    public List<PluginModel> getPlugins() {
        return this.stareProject.getPlugins();
    }

    public void clear() {
        this.stareProject.clear();
        this.setProjectFile(null);
    }

    public UUID getUuid() {
        return UUID.fromString(App.extractUrlId(this.url));
    }
}

