/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.export.poke;

import com.siams.cv.monitor.plugin.poke.model.FileUserMarkers;
import com.siams.cv.monitor.plugin.poke.model.LabelFeature;
import com.siams.cv.monitor.plugin.poke.model.StarePokePlugin;
import com.siams.cv.monitor.plugin.poke.model.UserMarker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ExportUserPokesCsv {
    private String delimiter = new String(",");

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void exportAs(File saveTo, StarePokePlugin data, File baseFile) throws IOException {
        Objects.requireNonNull(saveTo, "Save to file required");
        Objects.requireNonNull(data, "Stare poke plugin data required");
        Objects.requireNonNull(baseFile, "Base file required");
        if (!Files.exists(saveTo.toPath(), new LinkOption[0])) {
            saveTo.createNewFile();
        }
        List<LabelFeature> exportFeatures = data.getExportLabelFeatures();
        int columnCount = exportFeatures.size() + 1;
        try (FileOutputStream out = new FileOutputStream(saveTo);){
            ArrayList<String> headers = new ArrayList<String>(columnCount);
            headers.add("x");
            headers.add("y");
            headers.add("Class");
            String lineHeader = String.join((CharSequence)this.delimiter, headers);
            out.write(lineHeader.getBytes(StandardCharsets.UTF_8));
            out.write("\r\n".getBytes(StandardCharsets.UTF_8));
            CharSequence[] lineValues = new String[3];
            Optional<FileUserMarkers> optFileUserMarkers = data.findUserMarkers(baseFile);
            if (optFileUserMarkers.isPresent()) {
                FileUserMarkers fileUserMarkers = optFileUserMarkers.get();
                for (UserMarker userMarker : fileUserMarkers.getUserMarkers()) {
                    int x = (int)userMarker.getMarkerX();
                    int y = (int)userMarker.getMarkerY();
                    int classId = userMarker.getMarkerClassId();
                    lineValues[0] = String.valueOf(x);
                    lineValues[1] = String.valueOf(y);
                    lineValues[2] = String.valueOf(classId);
                    out.write(String.join((CharSequence)this.delimiter, lineValues).getBytes(StandardCharsets.UTF_8));
                    out.write("\r\n".getBytes());
                }
            }
        }
    }
}

