/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.export;

import com.siams.cv.monitor.export.ExportHtml;
import com.siams.cv.monitor.ui.content.container.FunctionStatistic;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class ExportFunctionsListLogsHtml
extends ExportHtml {
    private static final Logger logger = Logger.getLogger(ExportFunctionsListLogsHtml.class);
    private final List<FunctionStatistic> statistics;

    public ExportFunctionsListLogsHtml(List<FunctionStatistic> statistic) {
        Objects.requireNonNull(statistic, "Statistics required");
        this.statistics = statistic;
    }

    @Override
    public boolean export(File saveTo) throws IOException {
        if (this.htmlTemplatePath == null) {
            logger.error((Object)"Template path is null");
            return false;
        }
        if (this.htmlTemplatePath.isEmpty()) {
            logger.error((Object)"Template file is empty");
            return false;
        }
        boolean isOuterFile = new File(this.htmlTemplatePath).exists();
        boolean isResource = false;
        if (!isOuterFile) {
            try {
                URI uri = this.getClass().getResource(this.htmlTemplatePath).toURI();
                isResource = new File(uri).exists();
            }
            catch (Throwable uri) {
                // empty catch block
            }
        }
        if (!isOuterFile && !isResource) {
            logger.error((Object)"HTML template file not found");
            return false;
        }
        VelocityContext context = new VelocityContext();
        context.put("statistics", this.statistics);
        Template template = Velocity.getTemplate((String)this.htmlTemplatePath, (String)StandardCharsets.UTF_8.name());
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer);
        try (FileOutputStream out = new FileOutputStream(saveTo);){
            out.write(writer.toString().getBytes(StandardCharsets.UTF_8));
        }
        return true;
    }
}

