/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.application;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.BlockChain;
import com.siams.cv.monitor.dashboard.ChainDashboard;
import com.siams.cv.monitor.dashboard.data.ChildControl;
import com.siams.cv.monitor.dashboard.data.DashboardNode;
import com.siams.cv.monitor.dashboard.data.DashboardTree;
import com.siams.cv.monitor.dashboard.data.PropertyControl;
import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.help.HelpExecutor;
import com.siams.cv.monitor.message.ChainStatusChanged;
import com.siams.cv.monitor.message.NodeModelChanged;
import com.siams.cv.monitor.message.StareProjectSaved;
import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.Model;
import com.siams.cv.monitor.model.app.Project;
import com.siams.cv.monitor.model.app.ProjectManager;
import com.siams.cv.monitor.model.node.SmartLinkModel;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.node.UILinkModel;
import com.siams.cv.monitor.model.storage.IIDStorage;
import com.siams.cv.monitor.model.storage.NodeStorage;
import com.siams.cv.monitor.model.storage.ViewerModelStorage;
import com.siams.cv.monitor.model.viewer.BlockViewerModel;
import com.siams.cv.monitor.model.viewer.CompareViewerModel;
import com.siams.cv.monitor.model.viewer.ImageBorderViewerModel;
import com.siams.cv.monitor.model.viewer.ImageMaskViewerModel;
import com.siams.cv.monitor.model.viewer.ImageViewerModel;
import com.siams.cv.monitor.model.viewer.PlainTextViewerModel;
import com.siams.cv.monitor.model.viewer.ViewerKind;
import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.model.viewer.VoxelViewerModel;
import com.siams.cv.monitor.model.worker.WorkerType;
import com.siams.cv.monitor.transport.BlockBasedDataSource;
import com.siams.cv.monitor.ui.content.container.BlockTuner;
import com.siams.cv.monitor.ui.content.container.Desktop;
import com.siams.cv.monitor.ui.content.container.FunctionsList;
import com.siams.cv.monitor.ui.content.container.RootPane;
import com.siams.cv.monitor.ui.content.container.UILibraryFunctions;
import com.siams.cv.monitor.ui.content.container.ViewerContainer;
import com.siams.cv.monitor.ui.content.windows.OnlineHelp;
import com.siams.cv.monitor.ui.factory.SmartLink;
import com.siams.cv.monitor.ui.factory.UIBlock;
import com.siams.cv.monitor.ui.factory.UIComment;
import com.siams.cv.monitor.ui.factory.UILink;
import com.siams.cv.monitor.ui.factory.UIPort;
import com.siams.cv.monitor.ui.menu.ExamplesDialog;
import com.siams.cv.monitor.ui.menu.StareMainMenu;
import com.siams.cv.monitor.viewers.ui.content.CompareViewer;
import com.siams.cv.monitor.viewers.ui.content.PlainTextViewer;
import com.siams.cv.monitor.viewers.ui.content.Viewer;
import com.siams.cv.monitor.viewers.ui.content.ViewerFactory;
import com.siams.cv.monitor.viewers.ui.content.VisibleResultMetaData;
import com.siams.cv.monitor.viewers.ui.content.tools.SelectionTools;
import com.siams.dialogs.DialogManager;
import com.siams.general.Deletable;
import com.siams.javafx.utils.FxPlatform;
import com.siams.javafx.utils.FxTools;
import com.siams.notifications.StareNotification;
import com.siams.stare.api.Any;
import com.siams.stare.api.CommandStatus;
import com.siams.stare.api.StareApi;
import com.siams.stare.api.data.setting.Setting;
import com.siams.stare.api.data.worker.Worker;
import jakarta.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.stage.DirectoryChooser;
import javafx.util.Duration;
import net.algart.contexts.InterruptionException;
import net.algart.executors.api.HighLevelException;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.json.Jsons;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.greenrobot.eventbus.EventBus;

public class UserAction {
    private static final Logger logger = Logger.getLogger(UserAction.class);
    private static final App app = App.getInstance();

    public static void interruptChain(boolean prompt) {
        if (prompt) {
            DialogManager.showYesNoQuery((String)"Interrupt execution?", (String)"Confirmation").ifPresent(btnType -> {
                if (btnType == ButtonType.YES) {
                    UserAction.interruptChain(false);
                }
            });
        } else {
            app.rqInterruptProjectEvaluation().exceptionally(t -> {
                StareNotification.showWarn((String)t.getMessage());
                return null;
            });
        }
    }

    public static void editUiBlockModelCaption() {
        StareNode stareNode;
        if (app.getSelectedObjects().size() == 1 && UIBlock.class.isAssignableFrom((stareNode = app.getSelectedObjects().get(0)).getClass())) {
            UIBlock uiBlock = (UIBlock)stareNode;
            UserAction.editUiBlockModelCaption(uiBlock.getNodeModel());
        }
    }

    public static void openNewWindow() {
        UserAction.openNewWindow(null);
    }

    public static void openNewWindow(File initialProject) {
        try {
            BlockChain.openNewProject(initialProject);
        }
        catch (IOException e) {
            logger.error((Object)("Cannot start new process: " + e.getMessage()), (Throwable)e);
            StareNotification.showWarn((String)("Cannot start new process: " + String.valueOf(e)));
        }
    }

    public static void selectAllNodes() {
        app.selectNodes(NodeStorage.getInstance().find(StareNode.class, stareNode -> stareNode.getNode().getParent().getId().equals("groupElements")));
    }

    private static CompletableFuture<Operation> saveProjectIfNecessary() {
        CompletionStage<Operation> deferred = new CompletableFuture<Operation>();
        if (app.isProjectChanged()) {
            ButtonType buttonType = DialogManager.showQuery((String)"Save changes before reload?", (String)"Reload chain", (ButtonType[])new ButtonType[]{ButtonType.YES, ButtonType.NO, ButtonType.CANCEL}).orElse(ButtonType.CANCEL);
            if (buttonType == ButtonType.CANCEL) {
                ((CompletableFuture)deferred).complete(Operation.CANCELED);
            } else if (buttonType == ButtonType.YES) {
                File projectFile = app.getProject().getProjectFile();
                if (projectFile != null) {
                    deferred = app.saveStareProject(projectFile).thenApply(v -> Operation.SUCCESS);
                } else {
                    Optional<File> optSaveTo = ProjectManager.showSaveAsStareProjectDialog();
                    if (optSaveTo.isPresent()) {
                        File saveTo = optSaveTo.get();
                        deferred = app.saveStareProject(saveTo).thenApply(v -> Operation.SUCCESS);
                    } else {
                        ((CompletableFuture)deferred).completeExceptionally(new RuntimeException("Can't find project to save"));
                    }
                }
            } else {
                ((CompletableFuture)deferred).complete(Operation.SUCCESS);
            }
        } else {
            ((CompletableFuture)deferred).complete(Operation.SUCCESS);
        }
        return deferred;
    }

    public static CompletableFuture<Void> reloadCurrentChain() {
        return UserAction.saveProjectIfNecessary().thenCompose(operation -> {
            if (operation == Operation.CANCELED) {
                return CompletableFuture.completedFuture(null);
            }
            File projectFile = app.getProject().getProjectFile();
            if (projectFile != null) {
                return UserAction.loadingStareProject(projectFile);
            }
            return CompletableFuture.failedFuture(new RuntimeException("Invalid current chain file"));
        });
    }

    public static CompletableFuture<Void> loadingStareProject(File loadFrom) {
        return Desktop.getInstance().getRunIndicator().progress(app.loadStareProject(loadFrom), "Loading...").exceptionally(t -> {
            logger.error((Object)String.format("Failed to load chain: %s%n%s", loadFrom.getName(), t.getMessage()), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public static CompletableFuture<Void> loadingLeastRecentStareProject() {
        Path path = StareMainMenu.getInstance().getLeastRecentProject();
        return UserAction.loadingStareProject(path.toFile());
    }

    public static void importProjectConfiguration() {
        ProjectManager.showOpenImportProjectConfigDialog().ifPresent(file -> ((CompletableFuture)App.getInstance().rqUploadProjectConfiguration(file.toPath()).thenAccept(v -> StareNotification.showInfo((String)"Project configuration loaded"))).exceptionally(t -> {
            StareNotification.showWarn((String)"Failed import project configuration");
            return null;
        }));
    }

    public static void exportProjectConfiguration() {
        Path path = App.getInstance().getCurrentProjectConfigPath().orElseGet(() -> ProjectManager.showOpenExportProjectConfigDialog().map(File::toPath).orElse(null));
        if (path != null) {
            ((CompletableFuture)App.getInstance().saveProjectConfiguration(path).thenAccept(v -> StareNotification.showInfo((String)String.format("Project configuration saved: %s", path.getFileName())))).exceptionally(t -> {
                StareNotification.showWarn((String)"Failed export project configuration");
                return null;
            });
        }
    }

    public static void exportProjectConfigurationAs() {
        ProjectManager.showOpenExportProjectConfigDialog().ifPresent(file -> ((CompletableFuture)App.getInstance().saveProjectConfiguration(file.toPath()).thenAccept(v -> StareNotification.showInfo((String)String.format("Project configuration saved: %s", file.getName())))).exceptionally(t -> {
            StareNotification.showWarn((String)"Failed export project configuration");
            return null;
        }));
    }

    public static void createNewProject() {
        CompletableFuture<Object> saveStareProjectBeforeCreateNew = new CompletableFuture();
        saveStareProjectBeforeCreateNew.complete(null);
        if (app.isProjectChanged()) {
            ButtonType buttonType = DialogManager.showQuery((String)"Save changes before new chain creation?", (String)"Create new chain", (ButtonType[])new ButtonType[]{ButtonType.YES, ButtonType.NO, ButtonType.CANCEL}).orElse(ButtonType.CANCEL);
            if (buttonType == ButtonType.CANCEL) {
                return;
            }
            if (buttonType == ButtonType.YES) {
                File projectFile;
                File file = projectFile = app.getProject().getProjectFile() != null ? app.getProject().getProjectFile() : (File)ProjectManager.showSaveAsStareProjectDialog().orElse(null);
                if (projectFile != null) {
                    saveStareProjectBeforeCreateNew = app.saveStareProject(projectFile);
                }
            }
        }
        ((CompletableFuture)saveStareProjectBeforeCreateNew.thenCompose(v -> app.rqNewStareProject())).exceptionally(t -> {
            StareNotification.showWarn((String)String.format("Failed create project: %s", t.getMessage()));
            return null;
        });
    }

    private static Optional<OpenAs> askToOpenProjectAsNewWindow() {
        ButtonType newWindow = new ButtonType("New window");
        ButtonType thisWindow = new ButtonType("This window");
        return DialogManager.showQuery((String)"Open project in a new window?", (String)"How to open project", (ButtonType[])new ButtonType[]{newWindow, thisWindow, ButtonType.CANCEL}).map(buttonType -> {
            if (buttonType.equals(newWindow)) {
                return OpenAs.NEW_WINDOW;
            }
            if (buttonType.equals(thisWindow)) {
                return OpenAs.THIS_WINDOW;
            }
            return OpenAs.CANCEL;
        });
    }

    public static void openSolution(String solutionId) {
        UserAction.askToOpenProjectAsNewWindow().ifPresent(as -> {
            switch (as.ordinal()) {
                case 0: {
                    StareApi api = app.getStareApi();
                    CompletionStage deferred = ((CompletableFuture)api.createProject(app.getSessionUrl()).thenCompose(projectUrl -> api.loadSolution(projectUrl, solutionId).thenApply(v -> projectUrl))).thenAccept(BlockChain::openProject);
                    Desktop.getInstance().getRunIndicator().progress((CompletableFuture)deferred, "Load solution...").exceptionally(t -> {
                        StareNotification.showWarn((String)"Failed to load solution");
                        return null;
                    });
                    break;
                }
                case 1: {
                    UserAction.saveProjectIfNecessary().thenApply(operation -> {
                        if (operation == Operation.CANCELED) {
                            return null;
                        }
                        Desktop.getInstance().getRunIndicator().progress(app.rqLoadSolution(solutionId), "Load solution...").exceptionally(t -> {
                            StareNotification.showWarn((String)"Failed to load solution");
                            return null;
                        });
                        return null;
                    });
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported switch case");
                }
            }
        });
    }

    public static void openSolutionTemplate(String solutionTemplateId) {
        UserAction.askToOpenProjectAsNewWindow().ifPresent(as -> {
            switch (as.ordinal()) {
                case 0: {
                    StareApi api = app.getStareApi();
                    CompletionStage deferred = ((CompletableFuture)api.createProject(app.getSessionUrl()).thenCompose(projectUrl -> api.loadSolutionTemplate(projectUrl, solutionTemplateId).thenApply(v -> projectUrl))).thenAccept(BlockChain::openProject);
                    Desktop.getInstance().getRunIndicator().progress((CompletableFuture)deferred, "Load solution template...").exceptionally(t -> {
                        StareNotification.showWarn((String)"Failed to load solution template");
                        return null;
                    });
                    break;
                }
                case 1: {
                    UserAction.saveProjectIfNecessary().thenApply(operation -> {
                        if (operation == Operation.CANCELED) {
                            return null;
                        }
                        Desktop.getInstance().getRunIndicator().progress(app.rqLoadSolutionTemplate(solutionTemplateId), "Load solution template...").exceptionally(t -> {
                            StareNotification.showWarn((String)"Failed to load solution template");
                            return null;
                        });
                        return null;
                    });
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported switch case");
                }
            }
        });
    }

    public static void scrollToModel() {
        IIdentifiable introspected = app.getIntrospectedObject();
        if (introspected == null) {
            return;
        }
        IIDStorage iidStorage = IIDStorage.getInstance();
        if (UIBlock.class.isAssignableFrom(introspected.getClass())) {
            UIBlock uiBlock = (UIBlock)introspected;
            iidStorage.findFirst(uiBlock.getNodeModel().getWorkerType(), WorkerType.class).ifPresent(UserAction::scrollToModel);
        } else if (Model.class.isAssignableFrom(introspected.getClass())) {
            Model model = (Model)introspected;
            app.getProject().findModel((IIdentifiable)model, UIBlockModel.class).flatMap(blockModel -> iidStorage.findFirst(blockModel.getWorkerType(), WorkerType.class)).ifPresent(UserAction::scrollToModel);
        } else if (UIBlockModel.class.isAssignableFrom(introspected.getClass())) {
            UIBlockModel blockModel2 = (UIBlockModel)introspected;
            iidStorage.findFirst(blockModel2.getWorkerType(), WorkerType.class).ifPresent(UserAction::scrollToModel);
        }
    }

    public static void scrollToFunction() {
        IIdentifiable introspected = app.getIntrospectedObject();
        if (introspected == null) {
            return;
        }
        FunctionsList.getInstance().scrollToItem(introspected.getUuid());
    }

    public static void scrollToModel(WorkerType model) {
        int foundedIndex = UILibraryFunctions.scrollToModel(model);
        if (foundedIndex < 0) {
            UILibraryFunctions.getInstance().resolveTagMismatch(model);
        }
    }

    public static void findUsages(WorkerType workerToFind) {
        UserAction.findUsages(Collections.singletonList(workerToFind));
    }

    public static void findUsages(List<WorkerType> workersToFind) {
        File examplesDirectory;
        DirectoryChooser chooser = new DirectoryChooser();
        chooser.setTitle("Choose examples folder");
        Preferences preferences = Preferences.userNodeForPackage(ExamplesDialog.class);
        Path defaultExamplesFolder = Path.of("./examples", new String[0]);
        String initDir = preferences.get("examplesPackage.initDir", defaultExamplesFolder.toAbsolutePath().toString());
        File initDirectory = new File(initDir);
        if (!initDirectory.isDirectory()) {
            initDirectory = defaultExamplesFolder.toFile();
        }
        if (initDirectory.isDirectory()) {
            chooser.setInitialDirectory(initDirectory);
        }
        if ((examplesDirectory = chooser.showDialog(null)) == null) {
            return;
        }
        if (!examplesDirectory.isDirectory()) {
            StareNotification.showWarn((String)"Choose a directory");
        } else {
            Preferences.userNodeForPackage(ExamplesDialog.class).put("examplesPackage.initDir", examplesDirectory.getAbsolutePath());
            List<String> workerTypesAsStrings = workersToFind.stream().map(workerType -> workerType.getType().toString()).toList();
            CompletableFuture<List> findingProcess = CompletableFuture.supplyAsync(() -> {
                Predicate<File> tester = file -> {
                    if (!ChainSpecification.isChainSpecificationFile((Path)file.toPath())) {
                        return false;
                    }
                    try {
                        String content = new String(Files.readAllBytes(file.toPath()));
                        for (String workerType : workerTypesAsStrings) {
                            if (content.contains(workerType)) continue;
                            return false;
                        }
                        return true;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return false;
                    }
                };
                List<File> allFiles = UserAction.traverseDirectory(examplesDirectory);
                return allFiles.parallelStream().filter(tester).collect(Collectors.toList());
            });
            RootPane.getRunIndicator().progress(findingProcess, "Searching...").whenComplete((suitableExamples, throwable) -> {
                if (throwable != null) {
                    StareNotification.showWarn((String)("Error while finding usages: " + throwable.getMessage()));
                    throw new CompletionException(new Throwable(throwable.getMessage()));
                }
                if (suitableExamples.isEmpty()) {
                    StareNotification.showInfo((String)"No usages found");
                    return;
                }
                FxPlatform.RunFxThread(() -> {
                    ExamplesDialog dialog = new ExamplesDialog((List<File>)suitableExamples);
                    Optional optFile = dialog.showAndWait();
                    if (optFile.isPresent()) {
                        if (app.isVirginProject() && !app.isProjectChanged()) {
                            UserAction.loadingStareProject((File)optFile.get()).exceptionally(t -> {
                                StareNotification.showWarn((String)"Failed to load chain", (Throwable)t);
                                return null;
                            });
                        } else {
                            ButtonType newWindow = new ButtonType("New window");
                            ButtonType thisWindow = new ButtonType("This window");
                            DialogManager.showQuery((String)"Open found project in a new window?", (String)"How to open found project", (ButtonType[])new ButtonType[]{newWindow, thisWindow, ButtonType.CANCEL}).ifPresent(buttonType -> {
                                if (buttonType.equals(newWindow)) {
                                    UserAction.openNewWindow((File)optFile.get());
                                }
                                if (buttonType.equals(thisWindow)) {
                                    UserAction.loadingStareProject((File)optFile.get()).exceptionally(t -> {
                                        StareNotification.showWarn((String)"Failed to load chain", (Throwable)t);
                                        return null;
                                    });
                                }
                            });
                        }
                    }
                });
            });
        }
    }

    private static List<File> traverseDirectory(File directory) {
        LinkedList<File> suitableExamples = new LinkedList<File>();
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    suitableExamples.addAll(UserAction.traverseDirectory(file));
                    continue;
                }
                suitableExamples.add(file);
            }
        }
        return suitableExamples;
    }

    public static void showSpecification(WorkerType model) {
        UserAction.showSpecification(model.getUuid());
    }

    public static void showSpecification(UUID modelId) {
        app.rqGetData(String.format("P/model:%s", modelId), String.class).whenComplete((text, t) -> {
            PlainTextViewerModel viewerModel = new PlainTextViewerModel();
            viewerModel.setTitle(String.format("Executor JSON specification [%s]", modelId.toString()));
            PlainTextViewer viewer = (PlainTextViewer)ViewerFactory.create((ViewerKind)ViewerKind.PLAIN_TEXT, (ViewerModel)viewerModel);
            if (t == null) {
                viewer.setJsonText(Jsons.toPrettyString((JsonObject)Jsons.toJson((String)text)));
                viewer.enableTextFormatControlsProperty().set(true);
            } else {
                viewer.setText(t.getMessage());
            }
            FxPlatform.RunFxThread(() -> ViewerContainer.createAndShow((Viewer)viewer));
        });
    }

    public static void executeWorker(UUID workerId) {
        EventBus.getDefault().post((Object)ChainStatusChanged.started());
        app.rqEvaluateWorker(workerId).whenComplete((v, t) -> {
            if (t == null) {
                EventBus.getDefault().post((Object)ChainStatusChanged.paused());
            }
        });
    }

    public static void executeWorkerIfInstanceMode(UUID workerId) {
        if (app.isInstanceMode()) {
            UserAction.executeWorker(workerId);
        }
    }

    public static void executeChain() {
        EventBus.getDefault().post((Object)ChainStatusChanged.started());
        ((CompletableFuture)((CompletableFuture)app.rqEvaluateProject().thenCompose(status -> app.rqFirstProjectEvaluationErrorInfo().thenApply(errorInfo -> {
            errorInfo.ifPresent(ei -> {
                boolean notErrorInAlgorithm;
                boolean bl = notErrorInAlgorithm = InterruptionException.class.getName().equals(ei.error_class_name) || HighLevelException.class.getName().equals(ei.error_class_name);
                if (notErrorInAlgorithm) {
                    StareNotification.showInfo((String)"Notification", (String)ei.error_message, (Duration)Duration.INDEFINITE);
                    logger.info((Object)("Something occurred: " + ei.error_message + " (" + ei.error_class_name + ")"));
                } else {
                    String s = "An error occurs while chain execution" + (String)(ei.error_class_name == null || ei.error_class_name.isBlank() ? "" : " (" + ei.error_class_name + ")") + "\n" + ei.error_message;
                    StareNotification.showWarn((String)s);
                    logger.error((Object)s);
                }
            });
            return status;
        }))).thenAccept(status -> {
            if (status == CommandStatus.OK) {
                EventBus.getDefault().post((Object)ChainStatusChanged.paused());
            }
        })).exceptionally(t -> {
            EventBus.getDefault().post((Object)ChainStatusChanged.paused());
            StareNotification.showWarn((String)t.getMessage());
            return null;
        });
    }

    public static void executeChainStep() {
        EventBus.getDefault().post((Object)ChainStatusChanged.started());
        ((CompletableFuture)app.rqEvaluateProjectStep().thenAccept(status -> {
            if (status == CommandStatus.OK) {
                EventBus.getDefault().post((Object)ChainStatusChanged.paused());
            }
        })).exceptionally(t -> {
            StareNotification.showWarn((String)t.getMessage());
            EventBus.getDefault().post((Object)ChainStatusChanged.paused());
            return null;
        });
    }

    public static void resetChainStepIteration() {
        app.rqResetProjectEvaluation().exceptionally(t -> {
            StareNotification.showWarn((String)t.getMessage());
            return null;
        });
    }

    public static void addWorker(WorkerType model) {
        app.rqAddWorker(model).exceptionally(t -> {
            logger.error((Object)String.format("Failed add worker: %s", t.getMessage()), t);
            StareNotification.showWarn((String)String.format("Failed add worker: %s", t.getMessage()));
            return null;
        });
    }

    public static void editUiBlockModelCaption(UIBlockModel uiBlockModel) {
        DialogManager.showTextInput((String)"Type block custom caption:", (String)uiBlockModel.getCaption(), (String)"Block custom caption").ifPresent(caption -> {
            uiBlockModel.setCaption(caption);
            EventBus.getDefault().post((Object)new NodeModelChanged((Model)uiBlockModel));
        });
    }

    public static void editUiBlockModelComment(UIBlockModel uiBlockModel) {
        DialogManager.showWideText((String)"Type block custom comment: ", (String)uiBlockModel.getComment(), (String)"Block custom comment").ifPresent(comment -> {
            uiBlockModel.setComment(comment);
            EventBus.getDefault().post((Object)new NodeModelChanged((Model)uiBlockModel));
        });
    }

    public static void focusObject(IIdentifiable iid) {
        if (UIBlock.class.isAssignableFrom(iid.getClass())) {
            UIBlock uiBlock = (UIBlock)iid;
            Node node = uiBlock.getNode();
            UserAction.selectOneNode(uiBlock);
            Desktop.getInstance().changeViewportFocus(new Point2D(node.getLayoutX(), node.getLayoutY()), node.getLayoutBounds());
        }
    }

    public static void deleteObject(IIdentifiable iid, boolean displayConfirmation) {
        String deleteMessageFormat = "Delete selected object (%s)?";
        String errorMessageFormat = "Object (%s) can't be deleted, reason: '%s'";
        Class clazz = iid.getClass();
        String entity = UIBlock.class.isAssignableFrom(clazz) || UIBlockModel.class.isAssignableFrom(clazz) ? "block" : (UILink.class.isAssignableFrom(clazz) || UILinkModel.class.isAssignableFrom(clazz) ? "link" : (UIComment.class.isAssignableFrom(clazz) ? "comment" : (SmartLink.class.isAssignableFrom(clazz) || SmartLinkModel.class.isAssignableFrom(clazz) ? "smart link" : "unknown")));
        Optional optButtonType = Optional.empty();
        if (displayConfirmation) {
            optButtonType = DialogManager.showQuery((String)String.format("Delete selected object (%s)?", entity), (String)"Delete");
        }
        if (optButtonType.isPresent() || !displayConfirmation) {
            App.rqRemoveObject(iid).exceptionally(t -> {
                StareNotification.showWarn((String)String.format("Object (%s) can't be deleted, reason: '%s'", entity, t.getMessage()));
                return null;
            });
        }
    }

    public static void deleteSelectedObjects(boolean displayConfirmation) {
        String errorMessageFormat = "Objects can't be deleted, reason: '%s'";
        List<StareNode> selected = app.getSelectedObjects();
        if (selected.size() == 1) {
            UserAction.deleteObject(selected.get(0), displayConfirmation);
        } else if (selected.size() > 1) {
            Optional confirmation;
            if (displayConfirmation && (confirmation = DialogManager.showQuery((String)"Delete selected objects?", (String)"Confirmation")).isEmpty()) {
                return;
            }
            List<IIdentifiable> selectedIds = selected.stream().map(stareNode -> stareNode).collect(Collectors.toList());
            App.rqRemoveObjects(selectedIds).whenComplete((v, t) -> {
                app.unselectObjects();
                if (t != null) {
                    logger.warn((Object)String.format("Objects can't be deleted, reason: '%s'", t.getMessage()), t);
                    StareNotification.showWarn((String)String.format("Objects can't be deleted, reason: '%s'", t.getMessage()));
                }
            });
        }
    }

    public static void introspectObject(IIdentifiable iid) {
        app.setIntrospectObject(iid);
    }

    public static void selectOneNode(StareNode node) {
        app.selectOneNode(node);
    }

    public static void selectNode(StareNode node) {
        app.selectNode(node);
    }

    public static void selectNodes(List<StareNode> nodes) {
        app.selectNodes(nodes);
    }

    public static void unselectNode(StareNode node) {
        app.unselectOneNode(node);
    }

    private static void saveStareProject(File saveTo) {
        ((CompletableFuture)Desktop.getInstance().getRunIndicator().progress(app.saveStareProject(saveTo), "Saving...").thenAccept(v -> {
            StareNotification.showInfo((String)"Project saved");
            EventBus.getDefault().post((Object)new StareProjectSaved(app.getProject()));
        })).exceptionally(t -> {
            String cause = t.getCause() != null ? t.getCause().getMessage() : t.getMessage();
            String error = String.format("Cannot save chain file %s: %s", saveTo.getAbsolutePath(), cause);
            logger.error((Object)error, t);
            StareNotification.showWarn((String)"Failed to save chain", (String)error);
            return null;
        });
    }

    public static void saveStareProject() {
        File file = app.getProject().getProjectFile();
        if (file != null) {
            UserAction.saveStareProject(file);
        } else {
            UserAction.saveAsStareProject();
        }
    }

    public static void saveAsStareProject() {
        ProjectManager.showSaveAsStareProjectDialog().ifPresent(saveTo -> {
            Project project = app.getProject();
            ((CompletableFuture)app.rqSetObjectProperty(project, "chain.id", UUID.randomUUID().toString()).thenAccept(v -> UserAction.saveStareProject(saveTo))).exceptionally(t -> {
                String cause = t.getCause() != null ? t.getCause().getMessage() : t.getMessage();
                String error = String.format("Cannot save chain file %s: %s", saveTo.getAbsolutePath(), cause);
                logger.error((Object)error, t);
                StareNotification.showWarn((String)"Failed to save chain", (String)error);
                return null;
            });
        });
    }

    public static void unselectedNodes() {
        app.unselectObjects();
    }

    public static void showHelp(String url) {
        OnlineHelp.show(url);
    }

    private static void showHelpTemplate(VelocityContext context) {
        Template template = Velocity.getTemplate((String)"com/siams/cv/monitor/ui/content/block/quick-help.html");
        StringWriter stringWriter = new StringWriter();
        template.merge((Context)context, (Writer)stringWriter);
        String output = stringWriter.toString();
        OnlineHelp.show(output);
    }

    private static void showHelpSelectedBlock(UIBlockModel blockModel) {
        HelpExecutor helpExecutor = new HelpExecutor();
        helpExecutor.setBlockModel(blockModel);
        ((CompletableFuture)app.rqModel(String.format("/model:%s", blockModel.getWorkerType().toString())).thenCombine(app.rqGetObjectProperties((IIdentifiable)blockModel), (workerType, dRs) -> {
            helpExecutor.setDataProcessModel((WorkerType)workerType);
            helpExecutor.setProperties(dRs.getProperties());
            return null;
        })).whenComplete((v, t) -> {
            if (t == null) {
                FxPlatform.RunFxThread(() -> {
                    VelocityContext context = new VelocityContext();
                    context.put("executor", (Object)helpExecutor);
                    UserAction.showHelpTemplate(context);
                });
            } else {
                logger.error((Object)"Failed display quick help", t);
            }
        });
    }

    private static void showHelpSelectedDataProcessModel(WorkerType model) {
        HelpExecutor helpExecutor = new HelpExecutor();
        helpExecutor.setDataProcessModel(model);
        VelocityContext context = new VelocityContext();
        context.put("executor", (Object)helpExecutor);
        UserAction.showHelpTemplate(context);
    }

    public static void showHelpForObject(WorkerType model) {
        UserAction.showHelpSelectedDataProcessModel(model);
    }

    public static void showHelpSelectedObject() {
        IIdentifiable introspected = app.getIntrospectedObject();
        if (introspected == null) {
            return;
        }
        Class selectedClass = introspected.getClass();
        if (UIBlockModel.class.isAssignableFrom(selectedClass)) {
            UserAction.showHelpSelectedBlock((UIBlockModel)introspected);
        } else if (UIBlock.class.isAssignableFrom(selectedClass)) {
            UIBlock uiBlock = (UIBlock)introspected;
            UserAction.showHelpSelectedBlock(uiBlock.getNodeModel());
        }
    }

    public static void editUiBlockModelSystemName(UIBlockModel uiBlockModel) {
        ((CompletableFuture)app.rqGetObjectSystemPropertyIfExist((IIdentifiable)uiBlockModel, "name", "").thenAccept(systemName -> FxPlatform.RunFxThread(() -> DialogManager.showTextInput((String)"Type new system name", (String)systemName).ifPresent(newSystemName -> {
            String blockCaption = newSystemName.isEmpty() ? IIDStorage.getInstance().findFirst(w -> w.getUuid().equals(uiBlockModel.getWorkerType()), WorkerType.class).map(workerType -> workerType.getStructure().getName()).orElse("") : String.format("[%s]", newSystemName);
            ((CompletableFuture)app.rqSetObjectSystemProperty((IIdentifiable)uiBlockModel, "name", newSystemName).thenAccept(v -> {
                uiBlockModel.setCaption(blockCaption);
                EventBus.getDefault().post((Object)new NodeModelChanged((Model)uiBlockModel));
            })).exceptionally(v -> {
                StareNotification.showWarn((String)"Failed write system name");
                return null;
            });
        })))).exceptionally(v -> {
            StareNotification.showWarn((String)"Failed get system name");
            return null;
        });
    }

    public static void clearRegisteredComponentsFilter() {
        UILibraryFunctions.getInstance().clearTagFilter();
    }

    public static void setStopLoopPort(UIPort port) {
        throw new RuntimeException("Unimplemented");
    }

    public static void scrollToStopLoopDataProcess() {
        throw new RuntimeException("Unimplemented");
    }

    public static void addUIComment() {
        DialogManager.showWideText((String)"Type your comment:", (String)"", (String)"Add new UIComment").ifPresent(app::addUIComment);
    }

    public static void addViewerToCompare(UUID uuid) {
        UserAction.addViewerToCompare(uuid, 1);
    }

    public static void addViewerToCompare(UUID blockUuid, int groupNumber) {
        Objects.requireNonNull(blockUuid);
        if (0 >= groupNumber || groupNumber > 9) {
            throw new IllegalArgumentException("Group number should in range [1..9]");
        }
        UUID viewerId = CompareViewerModel.CreateUuid((int)groupNumber);
        CompareViewerModel compareViewerModel = ViewerModelStorage.getInstance().findFirst(viewerModel -> viewerModel.getUuid().equals(viewerId), CompareViewerModel.class).orElseGet(() -> {
            CompareViewerModel m = new CompareViewerModel(groupNumber);
            m.setCreatedByUser(Boolean.valueOf(true));
            m.setTitle(String.format("Compare viewer #%d", groupNumber));
            ViewerModelStorage.getInstance().addObject(m);
            return m;
        });
        if (!compareViewerModel.hasViewerModel(blockUuid)) {
            app.getProject().findModel(blockUuid, UIBlockModel.class).ifPresent(uiBlockModel -> app.rqViewerData((UIBlockModel)uiBlockModel).thenAccept(viewerData -> {
                VisibleResultMetaData meta = viewerData.getMeta();
                Map requiredData = viewerData.getData();
                ViewerKind kind = ViewerKind.from((String)meta.getModel(), (Map)requiredData);
                if (kind == ViewerKind.UNKNOWN) {
                    String error = "No data to display";
                    logger.warn((Object)"No data to display");
                    StareNotification.showWarn((String)"No data to display");
                    return;
                }
                VoxelViewerModel viewerModel = switch (kind) {
                    case ViewerKind.VOXEL -> new VoxelViewerModel(uiBlockModel.getUuid());
                    case ViewerKind.MASK -> new ImageMaskViewerModel(uiBlockModel.getUuid());
                    case ViewerKind.BOUNDARIES -> new ImageBorderViewerModel(uiBlockModel.getUuid());
                    default -> new ImageViewerModel(uiBlockModel.getUuid());
                };
                viewerModel.setTitle(uiBlockModel.getCaption());
                FxPlatform.RunFxThread(() -> UserAction.lambda$addViewerToCompare$75(compareViewerModel, (BlockViewerModel)viewerModel));
            }));
        }
        if (compareViewerModel.isShowing()) {
            compareViewerModel.toFront();
        } else {
            CompareViewer compareViewer = CompareViewer.instantiateWithDataSourceFactory((CompareViewerModel)compareViewerModel, blockModel -> new BlockBasedDataSource(blockModel.getBlockUuid()));
            ViewerContainer.createAndShow((Viewer)compareViewer);
        }
    }

    public static void showCompareViewer(int groupNumber) {
        UUID viewerId = CompareViewerModel.CreateUuid((int)groupNumber);
        ViewerModelStorage.getInstance().findFirst(model -> model.getUuid().equals(viewerId), CompareViewerModel.class).ifPresent(viewerModel -> {
            if (viewerModel.isShowing()) {
                viewerModel.toFront();
            } else {
                CompareViewer compareViewer = CompareViewer.instantiateWithDataSourceFactory((CompareViewerModel)viewerModel, blockModel -> new BlockBasedDataSource(blockModel.getBlockUuid()));
                ViewerContainer.createAndShow((Viewer)compareViewer);
            }
        });
    }

    public static void removeCompareViewer(UUID id) {
        ViewerModelStorage.removeById(id).ifPresent(Deletable::release);
    }

    public static void openBlockTuner(UIBlockModel blockModel) {
        BlockTuner blockTuner = new BlockTuner(blockModel);
        blockTuner.addSelectionTool(SelectionTools.RECTANGLE);
        blockTuner.addSelectionTool(SelectionTools.POINT);
        blockTuner.show();
    }

    public static boolean isSourceModelAvailable(ExecutorSpecification.SourceInfo sourceInfo) {
        return sourceInfo != null && sourceInfo.getSpecificationPath() != null;
    }

    public static void openSourceSpecificationFolder(ExecutorSpecification.SourceInfo sourceInfo, String executorName) {
        UserAction.openSource(sourceInfo == null ? null : sourceInfo.getSpecificationPath(), executorName, "model", false);
    }

    public static boolean isSourceModuleAvailable(ExecutorSpecification.SourceInfo sourceInfo) {
        return sourceInfo != null && sourceInfo.getModulePath() != null;
    }

    public static void openSourceModuleFolder(ExecutorSpecification.SourceInfo sourceInfo, String executorName) {
        String languageName = sourceInfo == null ? null : sourceInfo.getLanguageName();
        UserAction.openSource(sourceInfo == null ? null : sourceInfo.getModulePath(), executorName, (String)(languageName == null ? "module" : languageName + " module"), false);
    }

    public static boolean isSubChain(ExecutorSpecification.SourceInfo sourceInfo) {
        return sourceInfo != null && "chain".equals(sourceInfo.getLanguageName());
    }

    public static void openSubChainInNewWindow(ExecutorSpecification.SourceInfo sourceInfo, String executorName) {
        if (!UserAction.isSubChain(sourceInfo)) {
            StareNotification.showWarn((String)("The executor \"" + executorName + "\" is not a sub-chain"));
            return;
        }
        UserAction.openSource(sourceInfo.getModulePath(), executorName, "sub-chain", true);
    }

    private static void openSource(String source, String executorName, String whatToFind, boolean openChain) {
        Path path;
        String title = "executor \"" + executorName + "\"";
        if (source == null) {
            StareNotification.showWarn((String)("No information about source " + whatToFind + " path for " + title));
            return;
        }
        try {
            path = Paths.get(source, new String[0]);
        }
        catch (Exception e) {
            StareNotification.showWarn((String)("Invalid source " + whatToFind + " path for " + title + ": " + e.getMessage()));
            logger.error((Object)"Failed parse source path", (Throwable)e);
            return;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            StareNotification.showWarn((String)("Invalid source " + whatToFind + " path for " + title + ": it is not an existing path"));
            return;
        }
        if (openChain) {
            UserAction.openNewWindow(path.toFile());
            return;
        }
        FxTools.browseFileDirectory((Path)path);
    }

    private static ChildControl createChildControl(DashboardNode n, String description) {
        return new ChildControl(n.name, description);
    }

    private static DashboardNode createDashboardSettingNode(Setting setting) {
        List controls = setting.controls.stream().map(PropertyControl::new).collect(Collectors.toList());
        return new DashboardNode(setting.id, setting.name, setting.description, setting.url, controls);
    }

    private static void createDashboardSettingNode(List<Setting> settings, Setting settingNode, DashboardNode dashNode) {
        for (Setting setting : settings) {
            if (setting.parentId.isEmpty() || !setting.parentId.equals(settingNode.id)) continue;
            DashboardNode node = UserAction.createDashboardSettingNode(setting);
            dashNode.child.add(node);
            dashNode.controls.add(UserAction.createChildControl(node, node.description));
            UserAction.createDashboardSettingNode(settings, setting, node);
        }
    }

    private static DashboardNode createDashboardSettingNode(List<Setting> settings) {
        String rootId = "";
        DashboardNode settingNode = null;
        Setting settingRoot = null;
        for (Setting setting : settings) {
            if (!setting.parentId.equals(rootId)) continue;
            settingNode = UserAction.createDashboardSettingNode(setting);
            settingRoot = setting;
            break;
        }
        if (settingNode != null) {
            UserAction.createDashboardSettingNode(settings, settingRoot, settingNode);
        }
        return settingNode;
    }

    private static List<DashboardNode> createDashboardIODNodes(List<Worker> data) {
        return data.stream().map(worker -> {
            String nodeName = worker.systemName.isBlank() ? worker.name : worker.systemName;
            List controls = worker.model.controls.stream().map(PropertyControl::new).collect(Collectors.toList());
            DashboardNode node = new DashboardNode(worker.id, nodeName, worker.model.description, worker.url, controls);
            try {
                node.meta = VisibleResultMetaData.valueOf((String)worker.resultInfo);
            }
            catch (Throwable e) {
                logger.error((Object)"Failed parse meta data", e);
            }
            return node;
        }).collect(Collectors.toList());
    }

    private static CompletableFuture<DashboardTree> loadDashboardTree() {
        List resources = Collections.synchronizedList(new ArrayList());
        return ((CompletableFuture)app.rqGetListUrls("P/setting").thenCompose(urls -> CompletableFuture.allOf((CompletableFuture[])urls.stream().map(url -> app.rqGetData((String)url).thenAccept(resources::add)).toArray(CompletableFuture[]::new)))).thenApply(v -> {
            ArrayList<Setting> settings = new ArrayList<Setting>();
            ArrayList<Worker> inputs = new ArrayList<Worker>();
            ArrayList<Worker> outputs = new ArrayList<Worker>();
            ArrayList<Worker> data = new ArrayList<Worker>();
            for (Any any : resources) {
                any.getData().ifPresent(o -> {
                    if (o instanceof Setting) {
                        Setting setting = (Setting)o;
                        settings.add(setting);
                    } else if (o instanceof Worker) {
                        Worker worker = (Worker)o;
                        if (worker.model.isInput()) {
                            inputs.add(worker);
                        } else if (worker.model.isOutput()) {
                            outputs.add(worker);
                        } else if (worker.model.isData()) {
                            data.add(worker);
                        }
                    } else {
                        logger.warn((Object)String.format("Unsupported resource type: %s", o));
                    }
                });
            }
            DashboardTree tree = new DashboardTree();
            settings.sort((o1, o2) -> UserAction.compareNullable(o1.name, o2.name));
            inputs.sort((o1, o2) -> UserAction.compareNullable(o1.name, o2.name));
            outputs.sort((o1, o2) -> UserAction.compareNullable(o1.name, o2.name));
            data.sort((o1, o2) -> UserAction.compareNullable(o1.name, o2.name));
            tree.setting = UserAction.createDashboardSettingNode(settings);
            tree.input = UserAction.createDashboardIODNodes(inputs);
            tree.output = UserAction.createDashboardIODNodes(outputs);
            tree.data = UserAction.createDashboardIODNodes(data);
            return tree;
        });
    }

    public static void openDashboard() {
        if (app.getProject().getProjectFile() == null) {
            StareNotification.showWarn((String)"Failed open dashboard, save current project into file");
            return;
        }
        ChainDashboard dashboard = new ChainDashboard(app.getStareApi());
        dashboard.setWorkingDirectory(app.getProject().getProjectFile().getParentFile());
        String pokeAndLookProject = app.getProject().getStareProject().getPokeAndLookProject();
        dashboard.setPokeProject(pokeAndLookProject.isEmpty() ? null : new File(pokeAndLookProject));
        dashboard.setPokeProjectSaveCallback(pokeProjectPath -> app.getProject().getStareProject().setPokeAndLookProject((String)pokeProjectPath));
        ((CompletableFuture)Desktop.getInstance().getRunIndicator().progress(UserAction.loadDashboardTree(), "Opening dashboard...").thenAccept(dashboardTree -> {
            dashboard.setData(dashboardTree);
            FxPlatform.RunFxThread(() -> ((ChainDashboard)dashboard).show());
        })).exceptionally(t -> {
            logger.error((Object)"Failed open dashboard", t);
            StareNotification.showWarn((String)"Failed open dashboard");
            return null;
        });
    }

    public static void setFocus(Focus focus) {
        if (focus == Focus.REGISTERED_COMPONENT_FILTER) {
            UILibraryFunctions.getInstance().setFocus(focus);
        }
    }

    private static int compareNullable(String s1, String s2) {
        return s1 == null ? (s2 == null ? 0 : -1) : (s2 == null ? 1 : s1.compareTo(s2));
    }

    private static /* synthetic */ void lambda$addViewerToCompare$75(CompareViewerModel compareViewerModel, BlockViewerModel viewerModel) {
        compareViewerModel.addViewerModel((ViewerModel)viewerModel);
    }

    static enum Operation {
        SUCCESS,
        CANCELED;

    }

    public static enum Focus {
        REGISTERED_COMPONENT_FILTER;

    }

    static enum OpenAs {
        NEW_WINDOW,
        THIS_WINDOW,
        CANCEL;

    }
}

