/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.application;

import java.io.File;
import org.apache.log4j.Logger;

public class ProgramArguments {
    private Logger logger = Logger.getLogger(ProgramArguments.class);
    private String projectUrl = "";
    private File initialProject = null;
    private boolean debug = false;
    private boolean managedServer = false;

    public void parse(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            this.logger.debug((Object)String.format("arg[%d] '%s'", i, arg));
            if (arg.startsWith("project=")) {
                this.projectUrl = arg.substring("project=".length());
                continue;
            }
            if (arg.startsWith("debug=")) {
                try {
                    this.debug = Integer.parseInt(arg.substring("debug=".length())) != 0;
                }
                catch (Throwable ignore) {
                    this.debug = false;
                }
                continue;
            }
            if (arg.startsWith("initProject=")) {
                this.initialProject = new File(arg.substring("initProject=".length()));
                continue;
            }
            if (!arg.startsWith("managedServer=")) continue;
            this.managedServer = Boolean.parseBoolean(arg.substring("managedServer=".length()));
        }
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public File getInitialProject() {
        return this.initialProject;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isManagedServer() {
        return this.managedServer;
    }
}

