/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.application;

import com.siams.cv.monitor.application.ActionHistory;
import com.siams.cv.monitor.application.PreviewPooling;
import com.siams.cv.monitor.application.ProgramArguments;
import com.siams.cv.monitor.application.ProjectStatusPooling;
import com.siams.cv.monitor.application.StatisticPooling;
import com.siams.cv.monitor.entity.EntityFactory;
import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.message.ChainStatusChanged;
import com.siams.cv.monitor.message.DataProcessModelsLoaded;
import com.siams.cv.monitor.message.NewNodeAdded;
import com.siams.cv.monitor.message.NodeIntrospected;
import com.siams.cv.monitor.message.NodeRemoved;
import com.siams.cv.monitor.message.NodeSelected;
import com.siams.cv.monitor.message.ObjectPropertySet;
import com.siams.cv.monitor.message.StareChainConfigLoaded;
import com.siams.cv.monitor.message.StareChainConfigSaved;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.message.StareMonitorReady;
import com.siams.cv.monitor.message.StareProjectLoaded;
import com.siams.cv.monitor.message.StareProjectLoading;
import com.siams.cv.monitor.message.StareServerConnected;
import com.siams.cv.monitor.message.StareServerTimeout;
import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.PortType;
import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.app.Project;
import com.siams.cv.monitor.model.app.ProjectManager;
import com.siams.cv.monitor.model.app.StareProject;
import com.siams.cv.monitor.model.node.AnchorType;
import com.siams.cv.monitor.model.node.ConnectionModel;
import com.siams.cv.monitor.model.node.NodeModel;
import com.siams.cv.monitor.model.node.SmartLinkModel;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.node.UICommentModel;
import com.siams.cv.monitor.model.node.UILinkAnchorModel;
import com.siams.cv.monitor.model.node.UILinkModel;
import com.siams.cv.monitor.model.node.UIPortModel;
import com.siams.cv.monitor.model.statistic.Statistic;
import com.siams.cv.monitor.model.storage.IIDStorage;
import com.siams.cv.monitor.model.storage.NodeStorage;
import com.siams.cv.monitor.model.storage.ViewerModelStorage;
import com.siams.cv.monitor.model.viewer.CompareViewerModel;
import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.model.worker.DefaultWorkerType;
import com.siams.cv.monitor.model.worker.EKind;
import com.siams.cv.monitor.model.worker.SPort;
import com.siams.cv.monitor.model.worker.WorkerStructure;
import com.siams.cv.monitor.model.worker.WorkerType;
import com.siams.cv.monitor.model.worker.control.SCColor;
import com.siams.cv.monitor.model.worker.control.SCEItem;
import com.siams.cv.monitor.model.worker.control.SCEnum;
import com.siams.cv.monitor.model.worker.control.SCFile;
import com.siams.cv.monitor.model.worker.control.SCFileToSave;
import com.siams.cv.monitor.model.worker.control.SCFolder;
import com.siams.cv.monitor.model.worker.control.SCText;
import com.siams.cv.monitor.model.worker.control.SCValue;
import com.siams.cv.monitor.transport.data.response.DRsObjectProperties;
import com.siams.cv.monitor.transport.data.response.DRsSetObjectProperty;
import com.siams.cv.monitor.ui.content.container.Desktop;
import com.siams.cv.monitor.ui.content.container.RootPane;
import com.siams.cv.monitor.ui.content.windows.project.settings.ProjectSettings;
import com.siams.cv.monitor.ui.factory.Block;
import com.siams.cv.monitor.ui.factory.Connection;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.cv.monitor.ui.factory.NodeFactory;
import com.siams.cv.monitor.ui.factory.SmartLink;
import com.siams.cv.monitor.ui.factory.UIBlock;
import com.siams.cv.monitor.ui.factory.UIComment;
import com.siams.cv.monitor.ui.factory.UILink;
import com.siams.cv.monitor.ui.factory.UILinkAnchor;
import com.siams.cv.monitor.ui.factory.UIPort;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.cv.monitor.viewers.ui.content.VisibleResultMetaData;
import com.siams.dialogs.DialogManager;
import com.siams.notifications.StareNotification;
import com.siams.preferences.UIPreference;
import com.siams.stare.api.Any;
import com.siams.stare.api.Command;
import com.siams.stare.api.CommandStatus;
import com.siams.stare.api.ObjectStatus;
import com.siams.stare.api.ResourceFilter;
import com.siams.stare.api.StareApi;
import com.siams.stare.api.StareObject;
import com.siams.stare.api.data.Control;
import com.siams.stare.api.data.ErrorInfo;
import com.siams.stare.api.data.Port;
import com.siams.stare.api.data.worker.ExecutionStatus;
import com.siams.stare.api.data.worker.Model;
import com.siams.stare.api.data.worker.Worker;
import com.siams.stare.plugin.StareFxClientPlugin;
import io.grpc.StatusRuntimeException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.stage.Stage;
import net.algart.arrays.Arrays;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.SScalar;
import org.apache.log4j.Logger;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class App
implements Deletable,
UIPreference {
    public static final boolean EXPERIMENTAL_FEATURES = Arrays.SystemSettings.getBooleanProperty((String)"com.scichains.ide.experimental_features", (boolean)false);
    private static final Logger logger = Logger.getLogger(App.class);
    private final String sessionId = "default";
    private ProgramArguments programArguments = new ProgramArguments();
    private final List<StareFxClientPlugin> plugins = new ArrayList<StareFxClientPlugin>();
    private final List<StareNode> selectedObjects = new LinkedList<StareNode>();
    private IIdentifiable introspectedObject = null;
    private boolean isDesktopDragging = false;
    private Project project = ProjectManager.build();
    private Optional<Path> currentProjectConfigPath = Optional.empty();
    private Stage mainStage;
    private static App instance;
    private static final IIDStorage iidStorage;
    private final NodeStorage nodeStorage = NodeStorage.getInstance();
    private final Set<String> createdProjectUrls = new HashSet<String>();
    private StareApi stareApi;
    private StatisticPooling statisticPooling;
    private PreviewPooling previewPooling;
    private ProjectStatusPooling projectStatusPooling;
    private boolean instanceMode = false;
    private boolean enableServerCache = true;
    private boolean enableServerPreview = true;
    private boolean allOutputsNecessary = false;
    private boolean enableServerStatistic = true;
    private final List<DefaultWorkerType> globalModelCache = Collections.synchronizedList(new ArrayList());
    private final Boolean enableGlobalModelCache = true;
    private final ActionHistory actionHistory = new ActionHistory();

    private App() {
        this.initialize();
    }

    public static App getInstance() {
        if (instance == null) {
            instance = new App();
            instance.restorePreference();
        }
        return instance;
    }

    private void initialize() {
        this.subscribe();
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    @Subscribe
    public void onStareServerConnected(StareServerConnected event) {
        RootPane.getRunIndicator().progress(this.initializeAppAfterConnection(), "Connecting...").exceptionally(t -> {
            logger.error((Object)"Failed initialize app after connection", t);
            StareNotification.showWarn((String)t.getMessage());
            throw new CompletionException(new Throwable("Failed initialize app after connection"));
        });
    }

    @Subscribe
    public void onStareServerTimeout(StareServerTimeout event) {
    }

    @Subscribe
    public void onStareMonitorReady(StareMonitorReady event) {
        if (this.programArguments.getInitialProject() != null) {
            File projectFile = this.programArguments.getInitialProject();
            Desktop.getInstance().getRunIndicator().progress(this.loadStareProject(projectFile), "Loading...").exceptionally(t -> {
                String error = String.format("Failed to load chain: %s", projectFile.getName());
                StareNotification.showWarn((String)error);
                logger.error((Object)error, t);
                throw new CompletionException(new Throwable(error));
            });
        }
    }

    public void setMainStage(Stage stage) {
        this.mainStage = stage;
    }

    public Stage getMainStage() {
        return this.mainStage;
    }

    public boolean close() {
        if (this.actionHistory.isChanged()) {
            ButtonType dialogAnswer = DialogManager.showQuery((String)"Save changes before exit?", (String)"Save project", (ButtonType[])new ButtonType[]{ButtonType.YES, ButtonType.NO, ButtonType.CANCEL}).orElse(ButtonType.CANCEL);
            if (dialogAnswer == ButtonType.CANCEL) {
                return false;
            }
            if (dialogAnswer == ButtonType.YES) {
                File projectFile = this.project.getProjectFile();
                if (projectFile != null) {
                    this.saveStareProject(projectFile).thenAccept(v -> EventBus.getDefault().post((Object)new StareMonitorClosing()));
                } else {
                    ProjectManager.showSaveAsStareProjectDialog().ifPresent(saveTo -> this.saveStareProject((File)saveTo).thenAccept(v -> EventBus.getDefault().post((Object)new StareMonitorClosing())));
                }
                return true;
            }
        }
        EventBus.getDefault().post((Object)new StareMonitorClosing());
        return true;
    }

    private CompletableFuture<StareProject> rqGetStareProject(String projectUrl) {
        String resourceUrl = String.format("%s/property:stare-project", projectUrl);
        return ((CompletableFuture)this.rqGetDataIfExist(resourceUrl, "{}").thenApplyAsync(json -> {
            try {
                return StareProject.valueOf(json);
            }
            catch (Throwable t) {
                throw new CompletionException(t);
            }
        })).exceptionally(t -> {
            throw new CompletionException(String.format("Failed get chain: '%s'", resourceUrl), (Throwable)t);
        });
    }

    private CompletableFuture<Void> handleStareProject(String jsonStareProject) {
        return CompletableFuture.supplyAsync(() -> {
            Project project;
            if (!jsonStareProject.isEmpty()) {
                try {
                    project = ProjectManager.build(jsonStareProject);
                }
                catch (Throwable t) {
                    logger.error((Object)t.getMessage(), t);
                    project = ProjectManager.build();
                    StareNotification.showWarn((String)String.format("Can't load chain: %s", t));
                }
            } else {
                project = ProjectManager.build();
            }
            this.setProject(project);
            return project;
        }).thenAccept(v -> this.restoreCompareViewers());
    }

    public void selectOneNode(StareNode node) {
        this.selectedObjects.clear();
        this.selectedObjects.add(node);
        EventBus.getDefault().post((Object)new NodeSelected(this.selectedObjects));
    }

    public void selectNode(StareNode iid) {
        this.selectedObjects.add(iid);
        EventBus.getDefault().post((Object)new NodeSelected(this.selectedObjects));
    }

    public void selectNodes(List<StareNode> iid) {
        this.selectedObjects.clear();
        this.selectedObjects.addAll(iid);
        EventBus.getDefault().post((Object)new NodeSelected(this.selectedObjects));
    }

    public void unselectOneNode(StareNode iid) {
        if (this.selectedObjects.stream().anyMatch(selected -> selected.getUuid().equals(iid.getUuid()))) {
            this.selectedObjects.removeIf(selected -> selected.getUuid().equals(iid.getUuid()));
            EventBus.getDefault().post((Object)new NodeSelected(this.selectedObjects));
        }
    }

    public void unselectObjects() {
        this.selectedObjects.clear();
        EventBus.getDefault().post((Object)new NodeSelected(Collections.emptyList()));
    }

    public void setStareServerConnectedStatus(boolean isConnected) {
        if (isConnected) {
            EventBus.getDefault().post((Object)new StareServerConnected());
        } else {
            EventBus.getDefault().post((Object)new StareServerTimeout());
        }
    }

    private CompletableFuture<String> createProjectIfNecessary(String startUpProjectUrl) {
        return ((CompletableFuture)this.rqExist(startUpProjectUrl).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return CompletableFuture.completedFuture(startUpProjectUrl);
            }
            return this.rqNewStareProject();
        })).exceptionally(t -> {
            logger.error((Object)String.format("Failed verify existing startup project url: '%s'", startUpProjectUrl));
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<DefaultWorkerType> rqModel(String modelUrl) {
        return this.rqGetData(modelUrl).thenApplyAsync(any -> {
            if (any.getData().isEmpty()) {
                throw new CompletionException(new RuntimeException(String.format("Failed get model: '%s'", modelUrl)));
            }
            Object data = any.getData().get();
            if (data instanceof Model) {
                try {
                    return this.createWorkerTypeFromModel((Model)data, modelUrl);
                }
                catch (Throwable t) {
                    throw new CompletionException(new RuntimeException(String.format("Failed parse model json: %s", data)));
                }
            }
            if (data instanceof String) {
                String structureData = (String)data;
                try {
                    return this.createWorkerTypeFromJson(structureData, modelUrl);
                }
                catch (Throwable t) {
                    throw new CompletionException(new RuntimeException(String.format("Failed parse model json: %s", data)));
                }
            }
            throw new CompletionException(new RuntimeException("Unsupported model type"));
        });
    }

    private DefaultWorkerType createWorkerTypeFromJson(String structureData, String modelUrl) {
        try {
            WorkerStructure structure = WorkerStructure.valueOf((String)structureData);
            UUID structureId = structure.getUuid();
            DefaultWorkerType model = EntityFactory.createEntity(structureId, DefaultWorkerType.class);
            model.setStructure(structure);
            model.setUrl(modelUrl);
            return model;
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Failed parse model url: %s structure\n%s", modelUrl, structureData), t);
            throw new RuntimeException(t);
        }
    }

    private DefaultWorkerType createWorkerTypeFromModel(Model model, String modelUrl) {
        try {
            WorkerStructure structure = new WorkerStructure();
            structure.setUuid(UUID.fromString(model.id));
            structure.setName(model.name);
            structure.setCaption(model.name);
            structure.setDescription(model.description);
            model.tags.forEach(arg_0 -> ((WorkerStructure)structure).addTag(arg_0));
            structure.setCategory(model.category);
            structure.setLanguage(model.language.name);
            structure.setLanguageDetails(model.language.details);
            structure.setControls(model.controls.stream().map(control -> {
                SCFileToSave sControl = switch (control.editionType) {
                    default -> throw new MatchException(null, null);
                    case Control.EditionType.ENUM -> {
                        SCEnum scEnum = new SCEnum();
                        scEnum.setItems(control.items.stream().map(item -> {
                            SCEItem sceItem = new SCEItem();
                            sceItem.setCaption(item.caption);
                            sceItem.setValue(item.value);
                            return sceItem;
                        }).collect(Collectors.toList()));
                        yield scEnum;
                    }
                    case Control.EditionType.RANGE -> throw new RuntimeException("Unsupported yet");
                    case Control.EditionType.VALUE -> {
                        SCValue scValue = new SCValue();
                        scValue.setEditionRows(control.editionRows);
                        scValue.setMultiline(control.multiline);
                        yield scValue;
                    }
                    case Control.EditionType.FILE -> {
                        SCFile scFile = new SCFile();
                        scFile.setDialog(SCFile.DialogMode.of((String)control.dialog.toString()));
                        yield scFile;
                    }
                    case Control.EditionType.FILE_TO_SAVE -> new SCFileToSave();
                    case Control.EditionType.FOLDER -> new SCFolder();
                    case Control.EditionType.TEXT -> new SCText();
                    case Control.EditionType.COLOR -> new SCColor();
                };
                sControl.setAdvanced(Boolean.valueOf(control.isAdvanced));
                sControl.setName(control.name);
                sControl.setCaption(control.caption);
                sControl.setDescription(control.description);
                sControl.setHint(control.hint);
                sControl.setEditionType(control.editionType.toString());
                sControl.setValueType(control.valueType.toString());
                sControl.setDef(control.def);
                return sControl;
            }).collect(Collectors.toList()));
            if (model.isInput()) {
                structure.setKind(EKind.INPUT);
            } else if (model.isOutput()) {
                structure.setKind(EKind.OUTPUT);
            } else if (model.isData()) {
                structure.setKind(EKind.DATA);
            }
            structure.setInPorts(model.ports.stream().filter(port -> port.type == Port.Type.INPUT || port.type == Port.Type.INPUT_CONTROL).map(port -> {
                SPort sPort = new SPort();
                sPort.setCaption(port.caption);
                sPort.setHint(port.hint);
                sPort.setName(port.name);
                sPort.setOptional(port.advanced);
                sPort.setValueType(port.dataType.toString());
                switch (port.type) {
                    case INPUT: {
                        sPort.setPortType(PortType.INPUT);
                        break;
                    }
                    case INPUT_CONTROL: {
                        sPort.setPortType(PortType.INPUT_CONTROL);
                    }
                }
                return sPort;
            }).collect(Collectors.toList()));
            structure.setOutPorts(model.ports.stream().filter(port -> port.type == Port.Type.OUTPUT || port.type == Port.Type.OUTPUT_CONTROL).map(port -> {
                SPort sPort = new SPort();
                sPort.setCaption(port.caption);
                sPort.setHint(port.hint);
                sPort.setName(port.name);
                sPort.setOptional(port.advanced);
                sPort.setValueType(port.dataType.toString());
                switch (port.type) {
                    case OUTPUT: {
                        sPort.setPortType(PortType.OUTPUT);
                        break;
                    }
                    case OUTPUT_CONTROL: {
                        sPort.setPortType(PortType.OUTPUT_CONTROL);
                    }
                }
                return sPort;
            }).collect(Collectors.toList()));
            DefaultWorkerType workerType = EntityFactory.createEntity(structure.getUuid(), DefaultWorkerType.class);
            workerType.setStructure(structure);
            workerType.setUrl(modelUrl);
            return workerType;
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Failed create model url: %s", modelUrl), t);
            throw new RuntimeException(t);
        }
    }

    private CompletableFuture<List<WorkerType>> rqAllNecessaryModels(Project project) {
        List<Object> workerTypes;
        iidStorage.clear();
        CompletionStage deferredGlobalModels = new CompletableFuture();
        if (this.enableGlobalModelCache.booleanValue() && !this.globalModelCache.isEmpty()) {
            workerTypes = Collections.synchronizedList(new ArrayList<DefaultWorkerType>(this.globalModelCache));
            ((CompletableFuture)deferredGlobalModels).complete(workerTypes);
        } else {
            workerTypes = Collections.synchronizedList(new ArrayList());
            deferredGlobalModels = this.stareApi.getList("/model").thenCompose(modelUrls -> {
                CompletableFuture[] futures = (CompletableFuture[])modelUrls.stream().map(modelUrl -> this.rqModel((String)modelUrl).thenAccept(workerType -> {
                    workerTypes.add(workerType);
                    if (this.enableGlobalModelCache.booleanValue()) {
                        this.globalModelCache.add((DefaultWorkerType)workerType);
                    }
                })).toArray(CompletableFuture[]::new);
                return CompletableFuture.allOf(futures).thenCompose(v -> CompletableFuture.completedFuture(workerTypes));
            });
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)deferredGlobalModels).thenCompose(v -> this.stareApi.getList(String.format("%s/model", project.getUrl())))).thenCompose(modelUrls -> {
            CompletableFuture[] futures = (CompletableFuture[])modelUrls.stream().map(modelUrl -> this.stareApi.getData(modelUrl).thenAcceptAsync(any -> any.getData(String.class).ifPresent(structureData -> {
                boolean notExist;
                DefaultWorkerType model = this.createWorkerTypeFromJson((String)structureData, (String)modelUrl);
                List list = workerTypes;
                synchronized (list) {
                    notExist = workerTypes.stream().noneMatch(wt -> wt.getStructure().getUuid().equals(model.getUuid()));
                }
                if (notExist) {
                    workerTypes.add(model);
                }
            }))).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(futures).thenCompose(v -> CompletableFuture.completedFuture(workerTypes));
        })).thenApply(v -> {
            workerTypes.forEach(iidStorage::addObject);
            return workerTypes;
        })).exceptionally(t -> {
            throw new CompletionException("Failed all necessary models", (Throwable)t);
        });
    }

    public CompletableFuture<Boolean> rqExist(String url) {
        assert (this.stareApi != null);
        return url.isEmpty() ? CompletableFuture.completedFuture(false) : this.stareApi.exists(url);
    }

    public static String extractUrlId(String url) {
        int index = url.lastIndexOf(":");
        int end = url.lastIndexOf("/");
        if (end != -1 && end > index) {
            return url.substring(index != -1 ? index + 1 : 0, end);
        }
        return url.substring(index != -1 ? index + 1 : 0);
    }

    public CompletableFuture<Any> rqGetData(String url) {
        return this.stareApi.getData(url);
    }

    public CompletableFuture<Optional<UIBlockModel>> rqGetWorkerIfExist(String workerUrl) {
        return this.rqGetAnyIfExist(workerUrl).thenApply(any -> any.getData().map(o -> {
            String serializedWorker;
            if (Worker.class.isAssignableFrom(o.getClass())) {
                serializedWorker = ((Worker)o).tmp_json;
            } else if (String.class.isAssignableFrom(o.getClass())) {
                serializedWorker = (String)o;
            } else {
                throw new CompletionException(new RuntimeException("Unsupported worker information"));
            }
            return (UIBlockModel)UIBlockModel.valueOf((String)serializedWorker).orElseThrow(() -> new CompletionException(new RuntimeException("Failed parse serialized worker")));
        }));
    }

    public CompletableFuture<UIBlockModel> rqGetWorker(String workerUrl) {
        return this.rqGetWorkerIfExist(workerUrl).thenApply(opt -> (UIBlockModel)opt.orElseThrow(() -> new CompletionException(new RuntimeException("Requested resource not found"))));
    }

    public <T> CompletableFuture<T> rqGetData(String url, Class<T> clazz) {
        return this.stareApi.getData(url).thenApply(any -> any.getData(clazz).orElseThrow(() -> new CompletionException(new RuntimeException(String.format("Empty data: %s", url)))));
    }

    public <T> CompletableFuture<T> rqGetDataIfExist(String url, T def) {
        return ((CompletableFuture)this.rqExist(url).thenCompose(exists -> (exists != false ? this.stareApi.getData(url) : CompletableFuture.completedFuture(new Any(App.extractUrlId(url), def))).thenCompose(any -> CompletableFuture.completedFuture(any.getData(def.getClass()).map(value -> value).orElseThrow(() -> new CompletionException(new RuntimeException(String.format("Failed extract typed data url=%s, type=%s", url, def.getClass())))))))).exceptionally(t -> {
            logger.error((Object)String.format("Failed get data url=%s", url));
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<Any> rqGetAnyIfExist(String url) {
        return this.rqExist(url).thenCompose(exists -> (exists != false ? this.stareApi.getData(url) : CompletableFuture.completedFuture(new Any(App.extractUrlId(url), null))).thenCompose(CompletableFuture::completedFuture));
    }

    public CompletableFuture<Void> rqSetData(String url, Object any) {
        return this.stareApi.setData(url, any);
    }

    public CompletableFuture<Void> initializeAppAfterConnection() {
        return this.initializeAppAfterConnection(this.programArguments.getProjectUrl());
    }

    public CompletableFuture<Void> initializeAppAfterConnection(String projectUrl) {
        logger.trace((Object)"Clean up storage after connection");
        long t0 = System.currentTimeMillis();
        this.clearGlobalModelCache();
        this.nodeStorage.clear();
        this.project.clear();
        EventBus.getDefault().post((Object)new StareProjectLoading());
        ViewerModelStorage.getInstance().remove(viewerModel -> CompareViewerModel.class.isAssignableFrom(viewerModel.getClass()));
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.createProjectIfNecessary(projectUrl).thenCompose(url -> {
            this.project.setUrl((String)url);
            return this.rqGetStareProject(this.project.getUrl());
        })).thenCompose(stareProject -> ProjectManager.updateProjectVersionIfNecessary(this.project.getUrl(), stareProject))).thenApply(stareProject -> {
            this.project.setStareProject((StareProject)stareProject);
            return stareProject;
        })).thenCompose(stareProject -> this.rqAllNecessaryModels(this.project))).thenAccept(models -> EventBus.getDefault().post((Object)new DataProcessModelsLoaded((List<WorkerType>)models)))).thenCompose(v -> this.createDesktopNodes())).thenCompose(v -> this.rqSetObjectProperty(this.project, "__tmp.create_visible_result", this.enableServerPreview))).thenCompose(v -> this.rqSetObjectProperty(this.project, "__tmp.all_outputs_necessary", this.allOutputsNecessary))).thenCompose(v -> this.rqSetObjectProperty(this.project, "__tmp.enable.cache", this.enableServerCache))).thenAccept(v -> {
            logger.trace((Object)String.format("App initialized after connection in %d ms", System.currentTimeMillis() - t0));
            EventBus.getDefault().post((Object)new StareProjectLoaded(this.project));
            EventBus.getDefault().post((Object)new StareMonitorReady());
        })).exceptionally(t -> {
            String error = String.format("Failed initialize app after connection, startUpProjectUrl: %s", this.programArguments.getProjectUrl());
            logger.error((Object)error, t);
            throw new CompletionException(error, (Throwable)t);
        });
    }

    private void clearProject() {
        ViewerModelStorage.getInstance().clear();
        this.nodeStorage.remove(stareNode -> true).forEach(stareNode -> EventBus.getDefault().post((Object)new NodeRemoved(stareNode.getUuid())));
        this.project.clear();
        this.currentProjectConfigPath = Optional.empty();
    }

    public CompletableFuture<String> rqNewStareProject() {
        String currentProjectUrl = this.project.getUrl();
        this.unselectObjects();
        this.clearProject();
        EventBus.getDefault().post((Object)new StareProjectLoading());
        CompletableFuture<Object> removeIfNecessary = currentProjectUrl.isEmpty() ? CompletableFuture.completedFuture(null) : ((CompletableFuture)this.stareApi.remove(currentProjectUrl).thenCompose(v -> {
            this.createdProjectUrls.removeIf(url -> url.equals(currentProjectUrl));
            return this.rqExist(currentProjectUrl);
        })).thenAccept(exists -> {
            if (exists.booleanValue()) {
                logger.warn((Object)String.format("Removed project still exists on server: %s", currentProjectUrl));
            }
        });
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)removeIfNecessary.thenCompose(v -> this.stareApi.createSessionIfNecessary("default"))).thenCompose(v -> this.stareApi.createProject(String.format("/session:%s", "default")))).thenCompose(projectUrl -> {
            this.createdProjectUrls.add((String)projectUrl);
            this.project.setUrl((String)projectUrl);
            this.project.setProjectFile(null);
            return CompletableFuture.allOf(this.rqSetObjectProperty(this.project, "__tmp.create_statistic", this.enableServerStatistic), this.rqSetObjectProperty(this.project, "__tmp.create_visible_result", this.enableServerPreview), this.rqSetObjectProperty(this.project, "__tmp.enable.cache", this.enableServerCache));
        })).thenApply(v -> {
            EventBus.getDefault().post((Object)new StareProjectLoaded(this.project));
            return this.project.getUrl();
        })).thenCompose(projectUrl -> this.rqAllNecessaryModels(this.project))).thenAccept(models -> EventBus.getDefault().post((Object)new DataProcessModelsLoaded((List<WorkerType>)models)))).thenApply(v -> this.project.getUrl())).exceptionally(t -> {
            logger.error((Object)String.format("Failed remove project: %s", this.project.getUrl()));
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<Void> loadStareProject(File file) {
        this.clearProject();
        EventBus.getDefault().post((Object)new StareProjectLoading());
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.stareApi.uploadProject(this.project.getUrl(), file).thenApply(v -> {
            StareProject stareProject;
            try {
                stareProject = StareProject.valueOf(file);
            }
            catch (Throwable t) {
                throw new CompletionException(String.format("Failed to load chain: %s", file), t);
            }
            return stareProject;
        })).thenCompose(stareProject -> ProjectManager.updateProjectVersionIfNecessary(this.project.getUrl(), stareProject))).thenApply(stareProject -> {
            stareProject.removeModels(ViewerModel.class, anyViewerModel -> true);
            this.project.setStareProject((StareProject)stareProject);
            this.project.setProjectFile(file);
            this.project.setLoadedFromFile(true);
            return stareProject;
        })).thenCompose(stareProject -> this.createDesktopNodes())).thenCompose(v -> {
            try {
                return this.stareApi.setData("P/property:stare-project", this.project.getStareProject().toJson());
            }
            catch (Throwable t) {
                throw new CompletionException("Failed serialize chain", t);
            }
        })).thenCompose(v -> this.rqAllNecessaryModels(this.project))).thenAccept(workerModels -> EventBus.getDefault().post((Object)new DataProcessModelsLoaded((List<WorkerType>)workerModels)))).thenAccept(v -> EventBus.getDefault().post((Object)new StareProjectLoaded(this.project)))).exceptionally(t -> {
            logger.error((Object)String.format("Failed to load chain: %s", file.getAbsolutePath()), t);
            if (t instanceof CompletionException && t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof StatusRuntimeException) {
                StatusRuntimeException statusRuntimeException = (StatusRuntimeException)t;
                String description = statusRuntimeException.getStatus().getDescription();
                throw new CompletionException(new IOException(description));
            }
            throw new CompletionException((Throwable)t);
        });
    }

    private void setProject(Project project) {
        if (this.project != null && this.project != project) {
            this.project.release();
        }
        this.project = project;
    }

    public CompletableFuture<Void> saveProjectConfiguration(Path saveTo) {
        return this.rqProjectConfiguration().thenAccept(content -> {
            try {
                Files.writeString(saveTo, (CharSequence)content, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                this.currentProjectConfigPath = Optional.of(saveTo);
                EventBus.getDefault().post((Object)new StareChainConfigSaved(saveTo));
            }
            catch (Throwable t) {
                logger.error((Object)"Failed write project config", t);
                throw new CompletionException(t);
            }
        });
    }

    public CompletableFuture<Void> saveStareProject(File saveTo) {
        CompletableFuture[] prepare = (CompletableFuture[])this.project.findAllModels(UIBlockModel.class).stream().map(uiBlockModel -> this.rqSetObjectSystemProperty((IIdentifiable)uiBlockModel, "description", uiBlockModel.getComment().trim()).thenCompose(v -> this.rqSetObjectSystemProperty((IIdentifiable)uiBlockModel, "caption", uiBlockModel.getCaption().trim()))).toArray(CompletableFuture[]::new);
        return ((CompletableFuture)CompletableFuture.allOf(prepare).thenCompose(v -> this.stareApi.getData("P"))).thenAccept(any -> any.getData(String.class).ifPresent(json -> {
            try {
                ProjectManager.saveProject(saveTo, this.project, json);
                this.project.setProjectFile(saveTo);
            }
            catch (Throwable t) {
                throw new CompletionException("Failed build project json", t);
            }
        }));
    }

    private CompletableFuture<Void> createDesktopNodes() {
        logger.info((Object)String.format("Create desktop nodes: %s", Thread.currentThread()));
        long t0 = System.currentTimeMillis();
        List<NodeModel> nodeModels = this.project.findAllModels(NodeModel.class);
        CompletableFuture[] blockInitialized = (CompletableFuture[])nodeModels.stream().filter(nodeModel -> UIBlockModel.class.isAssignableFrom(nodeModel.getClass())).map(uiBlockModel -> ((Block)NodeFactory.createNode(uiBlockModel)).fxmlInitialized()).toArray(CompletableFuture[]::new);
        return ((CompletableFuture)CompletableFuture.allOf(blockInitialized).thenAccept(v -> {
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("[Profiler] App.createDesktopNodes (Blocks) %d ms", System.currentTimeMillis() - t0));
            }
        })).thenAccept(v -> {
            long t1 = System.currentTimeMillis();
            nodeModels.stream().filter(nodeModel -> !UIBlockModel.class.isAssignableFrom(nodeModel.getClass())).forEach(NodeFactory::createNode);
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("[Profiler] App.createAllDesktopNodes %d ms", System.currentTimeMillis() - t1));
            }
        });
    }

    public static CompletableFuture<List<String>> rqRemoveObject(IIdentifiable iid) {
        if (iid.getRelUrl().isEmpty()) {
            return CompletableFuture.completedFuture(App.removeFromStorage(iid.getUuid()).stream().map(node -> node.getUuid().toString()).collect(Collectors.toList()));
        }
        return App.rqRemoveResource(String.format("P%s", iid.getRelUrl()));
    }

    public static CompletableFuture<List<String>> rqRemoveStatistic(UUID statisticId) {
        String resourceUrl = String.format("P/statistic:%s", statisticId.toString());
        return App.rqRemoveResource(resourceUrl);
    }

    private static CompletableFuture<List<String>> rqRemoveResource(String url) {
        return ((CompletableFuture)App.instance.stareApi.remove(url).thenApply(removedUrls -> {
            try {
                removedUrls.forEach(removedUrl -> {
                    logger.debug((Object)String.format("removed: %s", removedUrl));
                    UUID uid = UUID.fromString(App.extractUrlId(removedUrl));
                    App.removeFromStorage(uid);
                });
            }
            catch (Throwable t) {
                logger.error((Object)"Failed remove object from storage", t);
            }
            return removedUrls;
        })).exceptionally(t -> {
            logger.error((Object)String.format("Failed remove resource=%s", url), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public static CompletableFuture<List<String>> rqRemoveObjects(List<IIdentifiable> iids) {
        Set removed = Collections.synchronizedSet(new HashSet());
        return CompletableFuture.allOf((CompletableFuture[])iids.stream().map(iid -> App.rqRemoveObject(iid).thenAccept(removed::addAll)).toArray(CompletableFuture[]::new)).thenApply(v -> new ArrayList(removed));
    }

    private static CompletableFuture<List<String>> rqRemoveResources(List<String> urls) {
        if (urls.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return ((CompletableFuture)App.instance.stareApi.remove(urls).thenApply(removedUrls -> {
            removedUrls.forEach(url -> {
                try {
                    UUID uid = UUID.fromString(url.substring(url.lastIndexOf(":") + 1));
                    App.removeFromStorage(uid);
                }
                catch (Throwable t) {
                    logger.error((Object)"Failed remove object from storage", t);
                }
            });
            return removedUrls;
        })).exceptionally(t -> {
            logger.error((Object)String.format("Failed remove resources=%s", String.join((CharSequence)", ", urls)));
            throw new CompletionException((Throwable)t);
        });
    }

    public static List<StareNode> removeFromStorage(UUID uid) {
        App app = App.getInstance();
        return app.nodeStorage.remove(uid).stream().peek(removed -> EventBus.getDefault().post((Object)new NodeRemoved(uid))).collect(Collectors.toList());
    }

    public CompletableFuture<UIBlock> rqAddWorker(WorkerType type) {
        return this.rqAddWorker(type, null);
    }

    public CompletableFuture<UIBlock> rqAddWorker(WorkerType type, Consumer<UIBlockModel> consumer) {
        if (type == null) {
            throw new IllegalArgumentException("Worker type is required");
        }
        String modelUrl = String.format("/model:%s", type.getUuid());
        return ((CompletableFuture)((CompletableFuture)this.stareApi.createWorker(this.project.getUrl(), modelUrl).thenCompose(this::rqGetWorker)).thenApply(uiBlockModel -> {
            this.project.addModel((com.siams.cv.monitor.model.Model)uiBlockModel);
            if (consumer != null) {
                consumer.accept((UIBlockModel)uiBlockModel);
            }
            UIBlock uiBlock = (UIBlock)NodeFactory.createNode((NodeModel)uiBlockModel);
            EventBus.getDefault().post((Object)new NewNodeAdded(uiBlock));
            return uiBlock;
        })).exceptionally(t -> {
            String error = String.format("Failed create worker url=%s, modelUrl=%s", this.project.getUrl(), modelUrl);
            logger.error((Object)error, t);
            throw new CompletionException(error, (Throwable)t);
        });
    }

    public Project getProject() {
        return this.project;
    }

    public Optional<Project> getOptionalProject() {
        return Optional.ofNullable(this.getProject());
    }

    public boolean isProjectChanged() {
        return this.actionHistory.isChanged();
    }

    public boolean isVirginProject() {
        return this.project.getStareProject().isVirginProject();
    }

    public CompletableFuture<UILink> rqCreateNewLink(UUID srcPortId, UUID destPortId) {
        Objects.requireNonNull(srcPortId, "Source port required");
        Objects.requireNonNull(destPortId, "Destination port required");
        String srcWorkerId = this.project.findModel(UIBlockModel.class, uiBlockModel -> uiBlockModel.findPort(srcPortId).isPresent()).map(uiBlockModel -> uiBlockModel.getUuid().toString()).orElse("");
        String dstWorkerId = this.project.findModel(UIBlockModel.class, uiBlockModel -> uiBlockModel.findPort(destPortId).isPresent()).map(uiBlockModel -> uiBlockModel.getUuid().toString()).orElse("");
        String srcPortUrl = String.format("%s/worker:%s/port:%s", this.project.getUrl(), srcWorkerId, srcPortId);
        String dstPortUrl = String.format("%s/worker:%s/port:%s", this.project.getUrl(), dstWorkerId, destPortId);
        return ((CompletableFuture)((CompletableFuture)this.stareApi.createLink(this.project.getUrl(), srcPortUrl, dstPortUrl).thenCompose(createdLinkUrl -> this.stareApi.getData(createdLinkUrl))).thenApply(any -> any.getData(String.class).map(json -> {
            Optional opt = UILinkModel.valueOf((String)json);
            if (opt.isEmpty()) {
                throw new CompletionException(new RuntimeException(String.format("Failed create link model from json:\n%s", json)));
            }
            UILinkModel uiLinkModel = (UILinkModel)opt.get();
            this.project.addModel((com.siams.cv.monitor.model.Model)uiLinkModel);
            UILink uiLink = (UILink)NodeFactory.createNode((NodeModel)uiLinkModel);
            EventBus.getDefault().post((Object)new NewNodeAdded(uiLink));
            return uiLink;
        }).orElseThrow(() -> new CompletionException(new RuntimeException("Unexpected link format (String.class required)"))))).exceptionally(t -> {
            String error = String.format("Failed create link project url=%s, srcPortId=%s, dstPortId=%s", this.project.getUrl(), srcPortId, destPortId);
            logger.error((Object)error, t);
            throw new CompletionException(error, (Throwable)t);
        });
    }

    public UILinkAnchor addUiLinkAnchor(AnchorType type) {
        UUID uuid = UUID.randomUUID();
        UILinkAnchorModel anchorModel = new UILinkAnchorModel();
        anchorModel.setUuid(uuid);
        anchorModel.setAnchorType(type);
        this.project.addModel((com.siams.cv.monitor.model.Model)anchorModel);
        UILinkAnchor uiLinkAnchor = (UILinkAnchor)NodeFactory.createNode((NodeModel)anchorModel);
        EventBus.getDefault().post((Object)new NewNodeAdded(uiLinkAnchor));
        return uiLinkAnchor;
    }

    public void addUIComment(String commentText) {
        UICommentModel commentModel = new UICommentModel();
        commentModel.setUuid(UUID.randomUUID());
        commentModel.setComment(commentText);
        Point2D center = Desktop.getInstance().getDesktopCenter();
        commentModel.setLayoutX(center.getX());
        commentModel.setLayoutY(center.getY());
        this.project.addModel((com.siams.cv.monitor.model.Model)commentModel);
        UIComment uiComment = (UIComment)NodeFactory.createNode((NodeModel)commentModel);
        EventBus.getDefault().post((Object)new NewNodeAdded(uiComment));
    }

    public <T> CompletableFuture<T> rqGetObjectProperty(IIdentifiable iid, String name, Class<T> clazz) {
        String url = String.format("P%s/property:%s", iid.getRelUrl(), name);
        return ((CompletableFuture)this.stareApi.getData(url).thenApply(any -> any.getData(clazz).orElseThrow(() -> new CompletionException(new RuntimeException("Failed convert data"))))).exceptionally(t -> {
            logger.error((Object)String.format("Failed get object property url=%s", url));
            throw new CompletionException((Throwable)t);
        });
    }

    public <T> CompletableFuture<T> rqGetObjectSystemPropertyIfExist(IIdentifiable iid, String name, T def) {
        return this.rqGetDataIfExist(String.format("P%s/system:%s", iid.getRelUrl(), name), def);
    }

    public <T> CompletableFuture<T> rqGetObjectPropertyIfExist(IIdentifiable iid, String name, T def) {
        return this.rqGetDataIfExist(String.format("P%s/property:%s", iid.getRelUrl(), name), def);
    }

    public CompletableFuture<Any> rqGetObjectPropertyIfExist(IIdentifiable iid, String name) {
        String url = String.format("P%s/property:%s", iid.getRelUrl(), name);
        return this.rqGetAnyIfExist(url);
    }

    public CompletableFuture<ProjectSettings> rqGetProjectSettings() {
        return this.rqGetProperties("P").thenApply(list -> {
            Optional<Any> optChainExecutor = list.stream().filter(any -> {
                String propertyName = App.extractUrlId(any.getUrl());
                if (!propertyName.equals("chain.executor")) {
                    return false;
                }
                Optional opt = any.getData(String.class);
                return opt.isPresent();
            }).findFirst();
            try {
                ProjectSettings projectSettings = optChainExecutor.isPresent() ? ProjectSettings.from((String)optChainExecutor.get().getData(String.class).get()) : new ProjectSettings();
                projectSettings.setGridSize(this.project.getRoot().getGridSize());
                projectSettings.setGridAdjust(this.project.getRoot().getGridAdjust());
                for (Any any2 : list) {
                    String propertyName;
                    switch (propertyName = App.extractUrlId(any2.getUrl())) {
                        case "chain.id": {
                            any2.getData(String.class).ifPresent(projectSettings::setId);
                            break;
                        }
                        case "chain.name": {
                            any2.getData(String.class).ifPresent(projectSettings::setName);
                            break;
                        }
                        case "chain.category": {
                            any2.getData(String.class).ifPresent(projectSettings::setCategory);
                            break;
                        }
                        case "chain.description": {
                            any2.getData(String.class).ifPresent(projectSettings::setDescription);
                            break;
                        }
                        case "chain.execution.all": {
                            any2.getData(Boolean.class).ifPresent(projectSettings::setAlwaysExecuteAll);
                            break;
                        }
                        case "chain.execution.strategy": {
                            any2.getData(String.class).ifPresent(executionStrategy -> projectSettings.setExecutionStrategy(ProjectSettings.ExecutionStrategy.from(executionStrategy)));
                            break;
                        }
                        case "chain.execution.multithreading": {
                            any2.getData(Boolean.class).ifPresent(projectSettings::setMultiThreading);
                            break;
                        }
                        case "chain.execution.ignore.exception": {
                            any2.getData(Boolean.class).ifPresent(projectSettings::setIgnoreExceptions);
                            break;
                        }
                        case "__tmp.enable.cache": {
                            any2.getData(Boolean.class).ifPresent(projectSettings::setCache);
                            break;
                        }
                        case "__tmp.create_visible_result": {
                            any2.getData(Boolean.class).ifPresent(projectSettings::setPreview);
                        }
                    }
                }
                return projectSettings;
            }
            catch (Throwable t) {
                throw new CompletionException("Failed create chain settings", t);
            }
        });
    }

    private CompletableFuture<List<Any>> rqGetProperties(String resourceUrl) {
        return ((CompletableFuture)this.stareApi.getList(String.format("%s/property", resourceUrl)).thenCompose(urls -> {
            List properties = Collections.synchronizedList(new ArrayList());
            CompletableFuture[] result = (CompletableFuture[])urls.stream().map(url -> this.rqGetAnyIfExist((String)url).thenAccept(properties::add)).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(result).thenApply(v -> properties);
        })).exceptionally(t -> {
            logger.error((Object)String.format("Failed get properties: %s", resourceUrl));
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<DRsObjectProperties> rqGetObjectProperties(IIdentifiable iid) {
        assert (this.project.findModelByUuid(iid.getUuid()).isPresent()) : "Unknown iid object";
        return ((CompletableFuture)this.stareApi.getList(String.format("P%s/property", iid.getRelUrl())).thenCompose(urls -> {
            List properties = Collections.synchronizedList(new ArrayList());
            CompletableFuture[] result = (CompletableFuture[])urls.stream().map(url -> this.stareApi.getData(url).thenAccept(any -> any.getData().ifPresent(data -> {
                logger.trace((Object)String.format("Received object property: %s", any.getUrl()));
                if (data instanceof Boolean) {
                    properties.add(new SimplePrimitive(App.extractUrlId(any.getUrl()), data));
                } else if (data instanceof Integer) {
                    properties.add(new SimplePrimitive(App.extractUrlId(any.getUrl()), data));
                } else if (data instanceof Double) {
                    properties.add(new SimplePrimitive(App.extractUrlId(any.getUrl()), data));
                } else if (data instanceof Long) {
                    properties.add(new SimplePrimitive(App.extractUrlId(any.getUrl()), data));
                } else if (data instanceof String) {
                    properties.add(new SimplePrimitive(App.extractUrlId(any.getUrl()), (String)data));
                } else {
                    logger.warn((Object)String.format("Unsupported property type: %s", data));
                }
            }))).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(result).thenApply(v -> {
                if (iid.getRelUrl().contains("/worker")) {
                    logger.debug((Object)String.format("Received object properties: %s", iid.getRelUrl()));
                    return new DRsObjectProperties(StareObject.WORKER, iid.getUuid(), properties);
                }
                logger.warn((Object)"Unsupported type");
                return new DRsObjectProperties(StareObject.WORKER, iid.getUuid(), Collections.emptyList());
            });
        })).exceptionally(t -> {
            logger.error((Object)String.format("Failed get object properties, rel url=%s", iid.getRelUrl()), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<CommandStatus> rqEvaluateProject() {
        return this.stareApi.executeCommand("P", Command.EVALUATE).exceptionally(t -> {
            logger.error((Object)String.format("Failed evaluate project: %s", t.getMessage()), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<CommandStatus> rqEvaluateProjectAsync() {
        return this.stareApi.executeCommand("P", Command.EVALUATE_ASYNC).exceptionally(t -> {
            logger.error((Object)String.format("Failed evaluate project: %s", t.getMessage()), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<CommandStatus> rqEvaluateWorker(UUID uuid) {
        return this.stareApi.executeCommand(String.format("P/worker:%s", uuid.toString()), Command.EVALUATE).exceptionally(t -> {
            logger.error((Object)String.format("Failed evaluate worker: %s", t.getMessage()), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<CommandStatus> rqEvaluateProjectStep() {
        return this.stareApi.executeCommand("P", Command.EVALUATE_STEP).exceptionally(t -> {
            logger.error((Object)String.format("Failed evaluate project step: %s", t.getMessage()), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<CommandStatus> rqInterruptProjectEvaluation() {
        return this.stareApi.executeCommand("P", Command.INTERRUPT).exceptionally(t -> {
            logger.error((Object)String.format("Failed interrupt project: %s", t.getMessage()), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<CommandStatus> rqResetProjectEvaluation() {
        return this.stareApi.executeCommand("P", Command.RESET_ITERATIONS).exceptionally(t -> {
            logger.error((Object)String.format("Failed interrupt project: %s", t.getMessage()), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<Void> rqSetWorkerProperty(UUID uuid, String name, Object data) {
        return ((CompletableFuture)this.stareApi.setData(String.format("P/worker:%s/property:%s", uuid, name), data).thenAccept(v -> {
            SimplePrimitive.PRIMITIVE_TYPE type;
            if (data instanceof Boolean) {
                type = SimplePrimitive.PRIMITIVE_TYPE.BOOL;
            } else if (data instanceof Integer) {
                type = SimplePrimitive.PRIMITIVE_TYPE.INT32;
            } else if (data instanceof Double) {
                type = SimplePrimitive.PRIMITIVE_TYPE.DOUBLE;
            } else if (data instanceof Long) {
                type = SimplePrimitive.PRIMITIVE_TYPE.INT64;
            } else if (data instanceof String) {
                type = SimplePrimitive.PRIMITIVE_TYPE.STR;
            } else {
                throw new IllegalArgumentException("Unsupported type");
            }
            DRsSetObjectProperty dRs = new DRsSetObjectProperty(uuid, StareObject.WORKER, new SimplePrimitive(name, type, data));
            EventBus.getDefault().post((Object)new ObjectPropertySet(dRs.getUuid(), dRs.getProperty()));
        })).exceptionally(t -> {
            logger.error((Object)String.format("Failed set object property uuid=%s, property name=%s", uuid, name));
            throw new CompletionException((Throwable)t);
        });
    }

    public List<StareNode> getSelectedObjects() {
        return this.selectedObjects;
    }

    public static boolean hasConnection(UIPortModel portModel) {
        UUID modelUuid = portModel.getUuid();
        return App.hasConnection(modelUuid);
    }

    public static boolean hasConnection(UIPort uiPort) {
        UUID portUuid = uiPort.getUuid();
        return App.hasConnection(portUuid);
    }

    private static boolean hasConnection(UUID uuid) {
        App app = App.getInstance();
        return app.nodeStorage.findFirst(UILink.class, uiLink -> {
            UILinkModel uiLinkModel = uiLink.getNodeModel();
            UUID srcUuid = uiLinkModel.getSrcPortUuid();
            assert (srcUuid != null);
            UUID dstUuid = uiLinkModel.getDestPortUuid();
            assert (dstUuid != null);
            return srcUuid.equals(uuid) || dstUuid.equals(uuid);
        }).isPresent();
    }

    public static List<Connection> findConnectedLinks(UUID blockId) {
        App app = App.getInstance();
        return app.nodeStorage.findFirst(UIBlock.class, blockId).map(App::findConnectedLinks).orElse(Collections.emptyList());
    }

    public static List<Connection> findConnectedLinks(UIBlock uiBlock) {
        App app = App.getInstance();
        return app.nodeStorage.find(Connection.class, connection -> {
            UUID destPortUuid;
            UUID srcPortUuid;
            if (UILink.class.isAssignableFrom(connection.getClass())) {
                UILinkModel linkModel = ((UILink)connection).getNodeModel();
                srcPortUuid = linkModel.getSrcPortUuid();
                destPortUuid = linkModel.getDestPortUuid();
            } else {
                SmartLinkModel smartLinkModel = ((SmartLink)connection).getNodeModel();
                srcPortUuid = smartLinkModel.getSrcPortUuid();
                destPortUuid = smartLinkModel.getDestPortUuid();
            }
            UIBlockModel nodeModel = uiBlock.getNodeModel();
            for (UIPortModel portModel : nodeModel.getPorts()) {
                UUID portUuid = portModel.getUuid();
                if (!portUuid.equals(srcPortUuid) && !portUuid.equals(destPortUuid)) continue;
                return true;
            }
            return false;
        });
    }

    public static List<UILink> findConnectedLinks(UIPort port) {
        return App.findConnectedLinks(port.getNodeModel());
    }

    public static List<UILink> findConnectedLinks(UIPortModel uiPortModel) {
        return App.findConnectedLinksByPortId(uiPortModel.getUuid());
    }

    public List<UIBlock> findConnectedBlocks(UIPortModel uiPortModel) {
        return App.findConnectedLinksByPortId(uiPortModel.getUuid()).stream().filter(uiLink -> {
            Node node = uiLink.getAnchorNode(uiPortModel.getPortType());
            return UIPort.class.isAssignableFrom(node.getClass());
        }).map(uiLink -> {
            UIPort uiConnectedPort = (UIPort)uiLink.getAnchorNode(uiPortModel.getPortType());
            return uiConnectedPort.getUIBlock();
        }).collect(Collectors.toList());
    }

    public static List<UILink> findConnectedLinksByPortId(UUID portId) {
        App app = App.getInstance();
        return app.nodeStorage.find(UILink.class, uiLink -> {
            UILinkModel uiLinkModel = uiLink.getNodeModel();
            UUID srcUuid = uiLinkModel.getSrcPortUuid();
            assert (srcUuid != null);
            UUID dstUuid = uiLinkModel.getDestPortUuid();
            assert (dstUuid != null);
            return srcUuid.equals(portId) || dstUuid.equals(portId);
        });
    }

    public static List<Connection> findConnections(UIPort port) {
        UUID portUuid = port.getUuid();
        App app = App.getInstance();
        return app.nodeStorage.find(Connection.class, connection -> {
            ConnectionModel model = (ConnectionModel)connection.getNodeModel();
            if (model.getSrcPortUuid() == null || model.getDestPortUuid() == null) {
                System.err.println(String.format("link %s src or dest port is null", model.getUuid()));
            }
            UUID srcUuid = model.getSrcPortUuid();
            assert (srcUuid != null);
            if (srcUuid.equals(portUuid)) {
                return true;
            }
            UUID dstUuid = model.getDestPortUuid();
            assert (dstUuid != null);
            return dstUuid.equals(portUuid);
        });
    }

    public boolean isDesktopDragging() {
        return this.isDesktopDragging;
    }

    public void setDesktopDragging(boolean desktopDragging) {
        this.isDesktopDragging = desktopDragging;
    }

    public CompletableFuture<Boolean> rqGetAutoContrastVisibleResult(UIBlockModel uiBlockModel) {
        return this.rqGetObjectSystemPropertyIfExist((IIdentifiable)uiBlockModel, "auto_contrast_preview_result", false);
    }

    public CompletableFuture<Void> rqSetAutoContrastVisibleResult(UIBlockModel uiBlockModel, boolean enableAutoContrast) {
        return this.rqSetObjectSystemProperty((IIdentifiable)uiBlockModel, "auto_contrast_preview_result", enableAutoContrast);
    }

    public CompletableFuture<Boolean> rqIsEnabled(UIBlockModel uiBlockModel) {
        return this.rqGetObjectSystemPropertyIfExist((IIdentifiable)uiBlockModel, "enabled", true);
    }

    public CompletableFuture<Void> rqSetEnabled(IIdentifiable iid, boolean enabled) {
        return this.rqSetObjectSystemProperty(iid, "enabled", enabled);
    }

    public void setIntrospectObject(IIdentifiable iid) {
        this.introspectedObject = iid;
        EventBus.getDefault().post((Object)new NodeIntrospected(iid));
    }

    public IIdentifiable getIntrospectedObject() {
        return this.introspectedObject;
    }

    public void initializePlugins(Node root) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"initializePlugin plugins...");
        }
        String propertyPlugins = System.getProperty("com.siams.cv.monitor.plugins");
        if (logger.isTraceEnabled()) {
            if (propertyPlugins != null) {
                logger.trace((Object)String.format("com.siams.cv.monitor.plugins set to '%s'", propertyPlugins));
            } else {
                logger.trace((Object)"com.siams.cv.monitor.plugins set to 'null'");
            }
        }
        if (propertyPlugins != null) {
            for (String pluginClazz : propertyPlugins.split(";")) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)String.format("trying to load plugin: '%s'", pluginClazz));
                }
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                try {
                    Class<?> clazz = cl.loadClass(pluginClazz);
                    StareFxClientPlugin plugin = (StareFxClientPlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    plugin.initializePlugin(root);
                    this.plugins.add(plugin);
                }
                catch (Throwable t) {
                    logger.error((Object)t.getMessage(), t);
                }
            }
        }
    }

    @Override
    public void release() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        if (this.statisticPooling != null) {
            this.statisticPooling.release();
        }
        if (this.previewPooling != null) {
            this.previewPooling.release();
        }
        this.actionHistory.release();
        this.createdProjectUrls.forEach(createdProjectUrl -> this.isStareApi(stareApi -> stareApi.remove(createdProjectUrl).exceptionally(t -> {
            logger.error((Object)String.format("Failed remove start up project: %s", createdProjectUrl), t);
            return null;
        })));
        this.plugins.forEach(StareFxClientPlugin::release);
        this.savePreference();
    }

    public static Optional<File> resolveAbsolutePath(File file) {
        if (file == null) {
            return Optional.empty();
        }
        return App.resolveAbsolutePath(file.getPath());
    }

    public static Optional<File> resolveAbsolutePath(String filePath) {
        if (filePath == null) {
            return Optional.empty();
        }
        File file = new File(filePath);
        if (file.isAbsolute()) {
            return Optional.of(file);
        }
        Project project = App.getInstance().getProject();
        if (project == null) {
            return Optional.empty();
        }
        File projectFile = project.getProjectFile();
        if (projectFile == null) {
            File cwd = project.getCurrentWorkingDirectory();
            if (cwd != null && Files.exists(cwd.toPath(), new LinkOption[0])) {
                return Optional.of(cwd.toPath().resolve(file.toPath()).toFile());
            }
            return Optional.empty();
        }
        File parent = projectFile.getParentFile();
        if (!Files.exists(parent.toPath(), new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(parent.toPath().resolve(file.toPath()).toFile());
    }

    public String createProjectUrl(UUID portUid) {
        if (portUid == null) {
            return "";
        }
        return this.project.findModel(UIBlockModel.class, uiBlockModel -> uiBlockModel.findPort(portUid).isPresent()).map(uiBlockModel -> String.format("%s/worker:%s/port:%s", this.project.getUrl(), uiBlockModel.getUuid().toString(), portUid)).orElse("");
    }

    public CompletableFuture<Void> rqUpdateLink(UILinkModel uiLinkModel) {
        String url = String.format("P%s", uiLinkModel.getRelUrl());
        String srcPortUrl = this.createProjectUrl(uiLinkModel.getSrcPortUuid());
        String dstPortUrl = this.createProjectUrl(uiLinkModel.getDestPortUuid());
        return this.stareApi.updateLink(url, srcPortUrl, dstPortUrl).exceptionally(t -> {
            logger.error((Object)String.format("Failed update link: %s", url));
            throw new CompletionException((Throwable)t);
        });
    }

    private void restoreCompareViewers() {
        System.out.println("Skip restoring compare viewers containers... make it lazy load");
    }

    public void setStareApi(StareApi stareApi) {
        this.stareApi = stareApi;
    }

    public void restorePreference() {
        this.instanceMode = this.getPreferredBoolean(this.createPreferenceName(App.class, "instanceMode"), false);
        this.enableServerCache = this.getPreferredBoolean(this.createPreferenceName(App.class, "enableServerCache"), true);
        this.enableServerPreview = this.getPreferredBoolean(this.createPreferenceName(App.class, "enableServerPreview"), true);
        this.allOutputsNecessary = this.getPreferredBoolean(this.createPreferenceName(App.class, "allOutputsNecessary"), false);
        this.enableServerStatistic = this.getPreferredBoolean(this.createPreferenceName(App.class, "enableServerStatistic"), true);
    }

    public void savePreference() {
        this.putPreferredBoolean(this.createPreferenceName(App.class, "instanceMode"), this.instanceMode);
        this.putPreferredBoolean(this.createPreferenceName(App.class, "enableServerCache"), this.enableServerCache);
        this.putPreferredBoolean(this.createPreferenceName(App.class, "enableServerPreview"), this.enableServerPreview);
        this.putPreferredBoolean(this.createPreferenceName(App.class, "allOutputsNecessary"), this.allOutputsNecessary);
        this.putPreferredBoolean(this.createPreferenceName(App.class, "enableServerStatistic"), this.enableServerStatistic);
    }

    public void isStareApi(Consumer<StareApi> consumer) {
        if (this.stareApi != null) {
            consumer.accept(this.stareApi);
        }
    }

    public CompletableFuture<List<String>> rqGetListIds(String url) {
        return this.stareApi.getList(url).thenApplyAsync(urls -> urls.stream().map(App::extractUrlId).collect(Collectors.toList()));
    }

    public CompletableFuture<List<String>> rqGetListIds(String url, ResourceFilter filter) {
        return this.stareApi.getList(url, filter).thenApplyAsync(urls -> urls.stream().map(App::extractUrlId).collect(Collectors.toList()));
    }

    public CompletableFuture<List<String>> rqGetListUrls(String url) {
        return this.stareApi.getList(url);
    }

    public CompletableFuture<List<String>> rqGetListUrls(String url, ResourceFilter filter) {
        return this.stareApi.getList(url, filter);
    }

    public CompletableFuture<Optional<String>> rqFirstProjectEvaluationError() {
        return this.stareApi.firstProjectEvaluationError(this.project.getUrl());
    }

    public CompletableFuture<Optional<ErrorInfo>> rqFirstProjectEvaluationErrorInfo() {
        return this.stareApi.firstProjectEvaluationErrorInfo(this.project.getUrl());
    }

    public StareApi getStareApi() {
        return this.stareApi;
    }

    public void initializeStatisticPooling() {
        this.statisticPooling = StatisticPooling.getInstance();
    }

    public void initializeProjectStatusPooling() {
        this.projectStatusPooling = ProjectStatusPooling.getInstance();
    }

    public void initializePreviewPooling() {
        this.previewPooling = PreviewPooling.getInstance();
    }

    private CompletableFuture<VisibleResultMetaData> rqGetVisibleResultMetaInformation(UIBlockModel uiBlockModel) {
        Objects.requireNonNull(uiBlockModel, "Block model required");
        String url = String.format("P%s/property:%s", uiBlockModel.getRelUrl(), "__tmp.visible_result_meta_information");
        return ((CompletableFuture)this.rqGetDataIfExist(url, "{}").thenApply(json -> {
            try {
                return VisibleResultMetaData.valueOf((String)json);
            }
            catch (Throwable t) {
                throw new CompletionException("Failed parse visible result meta data", t);
            }
        })).exceptionally(t -> {
            logger.error((Object)String.format("Failed get visible result meta information: %s", url), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<Statistic> rqGetStatistic(String url) {
        return ((CompletableFuture)this.rqGetAnyIfExist(url).thenApply(any -> {
            try {
                return Statistic.valueOf(any);
            }
            catch (Throwable t) {
                throw new CompletionException("Failed parse statistic json", t);
            }
        })).exceptionally(t -> {
            logger.error((Object)String.format("Failed get statistic rel url=%s", url), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<Optional<Statistic>> rqFindStatistic(UIBlockModel uiBlockModel) {
        Objects.requireNonNull(uiBlockModel, "Block model required");
        return this.rqGetStatistics().thenApply(statistics -> statistics.stream().filter(statistic -> statistic.getObjectUuid().equals(uiBlockModel.getUuid())).findFirst());
    }

    public CompletableFuture<ObjectStatus> rqGetProjectStatus() {
        return this.stareApi.getObjectStatus("P");
    }

    public CompletableFuture<List<Any>> rqGetWorkersStatus(Collection<String> objectIds) {
        List urls = objectIds.stream().map(id -> String.format("P/worker:%s", id)).collect(Collectors.toList());
        return this.stareApi.getObjectsStatus(urls);
    }

    public CompletableFuture<List<Any>> getObjectsStatus(List<String> urls) {
        return this.stareApi.getObjectsStatus(urls);
    }

    public CompletableFuture<List<Statistic>> rqGetStatistics() {
        return this.rqGetListUrls("P/statistic").thenCompose(urls -> {
            logger.trace((Object)String.format("list statistic size: %d", urls.size()));
            List statistic = Collections.synchronizedList(new ArrayList());
            CompletableFuture[] result = (CompletableFuture[])urls.stream().map(url -> ((CompletableFuture)this.rqGetStatistic((String)url).thenAccept(statistic::add)).exceptionally(t -> null)).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(result).thenApply(v -> statistic);
        });
    }

    public CompletableFuture<List<Statistic>> rqGetStatistics(ResourceFilter filter) {
        return ((CompletableFuture)((CompletableFuture)this.rqGetListUrls("P/statistic", filter).thenCompose(urls -> this.rqGetListAnyIfExistWithWaiting((List<String>)urls, null))).thenApply(entities -> entities.parallelStream().map(Statistic::valueOf).collect(Collectors.toList()))).thenApply(statistics -> statistics);
    }

    public CompletableFuture<ViewerData> rqViewerData(UIBlock uiBlock) {
        Objects.requireNonNull(uiBlock, "UIBlock required");
        return this.rqViewerData(uiBlock.getNodeModel());
    }

    public CompletableFuture<ViewerData> rqViewerData(UIBlockModel uiBlockModel) {
        Objects.requireNonNull(uiBlockModel, "Block model required");
        return ((CompletableFuture)this.rqGetVisibleResultMetaInformation(uiBlockModel).thenCompose(visibleResultMetaData -> {
            logger.debug((Object)"preparing required data map");
            Map requiredData = Collections.synchronizedMap(new HashMap());
            CompletableFuture[] result = (CompletableFuture[])visibleResultMetaData.getPorts().stream().map(port -> {
                String name = port.getName();
                UUID uid = port.getUuid();
                return this.rqGetAnyIfExist(String.format("P/cache:%s", uid)).thenAccept(any -> any.getData().ifPresent(value -> {
                    Data data = null;
                    if (Data.class.isAssignableFrom(value.getClass())) {
                        data = (Data)value;
                    } else if (value instanceof String) {
                        data = SScalar.of((Object)value);
                    }
                    requiredData.put(name, data);
                }));
            }).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(result).thenApply(v -> new ViewerData(requiredData, visibleResultMetaData));
        })).exceptionally(t -> {
            logger.error((Object)String.format("Failed get viewer data of block: %s", uiBlockModel), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public <T> CompletableFuture<Void> rqSetObjectSystemProperty(IIdentifiable iid, String name, T value) {
        String url = String.format("P%s/system:%s", iid.getRelUrl(), name);
        return this.stareApi.setData(url, value).exceptionally(t -> {
            logger.error((Object)String.format("Failed set object system property, url=%s", url));
            throw new CompletionException((Throwable)t);
        });
    }

    public <T> CompletableFuture<Void> rqSetObjectProperty(IIdentifiable iid, String name, T value) {
        return this.rqSetProperty(String.format("P%s", iid.getRelUrl()), name, value);
    }

    private <T> CompletableFuture<Void> rqSetProperty(String resourceUrl, String name, T value) {
        String url = String.format("%s/property:%s", resourceUrl, name);
        return this.stareApi.setData(url, value).exceptionally(t -> {
            logger.error((Object)String.format("Failed set object property, url=%s", url));
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<List<UILink>> unplugLinksFromPort(UIPortModel uiPortModel) {
        List<UILink> connectedLinks = App.findConnectedLinks(uiPortModel);
        if (connectedLinks.isEmpty()) {
            throw new RuntimeException("Connected links required");
        }
        PortType portType = uiPortModel.getPortType();
        if (!portType.isInput() && !portType.isOutput()) {
            throw new RuntimeException(String.format("Unsupported port type: %s", this));
        }
        CompletableFuture[] result = (CompletableFuture[])connectedLinks.stream().map(uiLink -> {
            UILinkModel uiLinkModel = uiLink.getNodeModel();
            UILinkModel uiLinkUpdatingModel = new UILinkModel.Builder().setUuid(uiLink.getUuid()).setSrcPortUuid(portType.isOutput() ? null : uiLinkModel.getSrcPortUuid()).setDestPortUuid(portType.isInput() ? null : uiLinkModel.getDestPortUuid()).build();
            return this.rqUpdateLink(uiLinkUpdatingModel).thenAccept(v -> {
                if (portType.isOutput()) {
                    uiLinkModel.setSrcPortUuid(null);
                } else if (portType.isInput()) {
                    uiLinkModel.setDestPortUuid(null);
                }
            });
        }).toArray(CompletableFuture[]::new);
        return ((CompletableFuture)CompletableFuture.allOf(result).thenApply(v -> connectedLinks)).exceptionally(t -> {
            logger.error((Object)String.format("Failed unplug links from port: %s", uiPortModel), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<List<UILink>> plugLinksToPort(List<UILink> links, UIPortModel uiPortModel) {
        PortType portType = uiPortModel.getPortType();
        CompletableFuture[] result = (CompletableFuture[])links.stream().map(uiLink -> {
            UILinkModel uiLinkModel = uiLink.getNodeModel();
            UILinkModel uiLinkUpdatingModel = new UILinkModel.Builder().setUuid(uiLink.getUuid()).setSrcPortUuid(portType.isOutput() ? uiPortModel.getUuid() : uiLinkModel.getSrcPortUuid()).setDestPortUuid(portType.isInput() ? uiPortModel.getUuid() : uiLinkModel.getDestPortUuid()).build();
            return this.rqUpdateLink(uiLinkUpdatingModel).thenAccept(v -> uiLinkModel.setPort(uiPortModel));
        }).toArray(CompletableFuture[]::new);
        return ((CompletableFuture)CompletableFuture.allOf(result).thenApply(v -> links)).exceptionally(t -> {
            logger.error((Object)String.format("Failed plug links to port: %s", uiPortModel));
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<Void> rqSetProjectSettings(ProjectSettings projectSettings) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("chain.executor", projectSettings.getExecutorText());
        properties.put("chain.id", projectSettings.getId());
        properties.put("chain.name", projectSettings.getName().strip());
        properties.put("chain.category", projectSettings.getCategory().strip());
        properties.put("chain.description", projectSettings.getDescription());
        properties.put("chain.execution.strategy", projectSettings.getExecutionStrategy().GetId());
        properties.put("chain.execution.all", projectSettings.isAlwaysExecuteAll());
        properties.put("chain.execution.ignore.exception", projectSettings.isIgnoreExceptions());
        properties.put("chain.execution.multithreading", projectSettings.isMultiThreading());
        return CompletableFuture.allOf((CompletableFuture[])properties.keySet().stream().map(name -> this.rqSetProperty("P", (String)name, (Object)properties.get(name))).toArray(CompletableFuture[]::new)).exceptionally(t -> {
            logger.error((Object)String.format("Failed set chain settings: %s", this.project.getUrl()), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public void setProgramArguments(ProgramArguments programArguments) {
        this.programArguments = programArguments;
    }

    public ProgramArguments getProgramArguments() {
        return this.programArguments;
    }

    public boolean isInstanceMode() {
        return this.instanceMode;
    }

    public void setInstanceMode(boolean instanceMode) {
        this.instanceMode = instanceMode;
    }

    public boolean isEnableServerCache() {
        return this.enableServerCache;
    }

    public void setEnableServerCache(boolean enableServerCache) {
        this.enableServerCache = enableServerCache;
    }

    public boolean isEnableServerPreview() {
        return this.enableServerPreview;
    }

    public void setEnableServerPreview(boolean enableServerPreview) {
        this.enableServerPreview = enableServerPreview;
        if (enableServerPreview) {
            this.previewPooling.startPooling();
        } else {
            this.previewPooling.stopPooling();
        }
    }

    public boolean isAllOutputsNecessary() {
        return this.allOutputsNecessary;
    }

    public void setAllOutputsNecessary(boolean allOutputsNecessary) {
        this.allOutputsNecessary = allOutputsNecessary;
    }

    public boolean isEnableServerStatistic() {
        return this.enableServerStatistic;
    }

    public void setEnableServerStatistic(boolean enableServerStatistic) {
        this.enableServerStatistic = enableServerStatistic;
        if (enableServerStatistic) {
            this.statisticPooling.startPooling();
        } else {
            this.statisticPooling.stopPooling();
        }
    }

    public CompletableFuture<Void> rqUploadProjectConfiguration(Path loadFrom) {
        EventBus.getDefault().post((Object)ChainStatusChanged.executing());
        return this.stareApi.uploadProjectConfiguration("P", loadFrom.toFile()).thenAccept(v -> {
            this.currentProjectConfigPath = Optional.of(loadFrom);
            EventBus.getDefault().post((Object)new StareChainConfigLoaded(loadFrom));
        });
    }

    public Optional<Path> getCurrentProjectConfigPath() {
        return this.currentProjectConfigPath;
    }

    public CompletionStage<List<Any>> rqGetListAnyIfExist(List<String> urls) {
        List entities = Collections.synchronizedList(new ArrayList());
        CompletableFuture[] result = (CompletableFuture[])urls.stream().map(url -> ((CompletableFuture)this.rqGetAnyIfExist((String)url).thenAccept(any -> {
            logger.info((Object)String.format("added preview: %s", any.getUrl()));
            entities.add(any);
        })).exceptionally(t -> null)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(result).thenApply(v -> entities);
    }

    public CompletionStage<List<Any>> rqGetListAnyIfExistWithWaiting(List<String> urls, Consumer<Any> onEach) {
        ArrayList entities = new ArrayList();
        return this.rqForEachAnyIfExistWithWaiting(urls, any -> {
            entities.add(any);
            if (onEach != null) {
                onEach.accept((Any)any);
            }
        }).thenApply(v -> entities);
    }

    public CompletionStage<Void> rqForEachAnyIfExistWithWaiting(List<String> urls, Consumer<Any> onEach) {
        return CompletableFuture.supplyAsync(() -> {
            for (String url : urls) {
                try {
                    Any any = this.rqGetAnyIfExist(url).get();
                    onEach.accept(any);
                    logger.debug((Object)String.format("added preview: %s", any.getUrl()));
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error((Object)"Failed get list of entities", (Throwable)e);
                    break;
                }
            }
            return null;
        });
    }

    private void clearGlobalModelCache() {
        this.globalModelCache.clear();
    }

    public CompletableFuture<String> rqProjectConfiguration() {
        return this.stareApi.getProjectConfiguration("P").thenApply(any -> (String)any.getData(String.class).orElseThrow(() -> {
            throw new CompletionException(new RuntimeException("Failed get project configuration"));
        }));
    }

    public String getSessionUrl() {
        return "/session:default";
    }

    public CompletableFuture<Void> rqLoadSolution(String solutionId) {
        return ((CompletableFuture)this.stareApi.loadSolution(this.project.getUrl(), solutionId).thenCompose(v -> this.initializeAppAfterConnection(this.project.getUrl()))).exceptionally(t -> {
            logger.error((Object)String.format("Failed to load solution: %s", solutionId));
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<Void> rqLoadSolutionTemplate(String solutionTemplateId) {
        return ((CompletableFuture)this.stareApi.loadSolutionTemplate(this.project.getUrl(), solutionTemplateId).thenCompose(v -> this.initializeAppAfterConnection(this.project.getUrl()))).exceptionally(t -> {
            logger.error((Object)String.format("Failed to load solution template: %s", solutionTemplateId));
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletionStage<CommandStatus> rqBuildPreview(UUID workerId) {
        return this.stareApi.executeCommand(String.format("P/worker:%s", workerId.toString()), Command.BUILD_PREVIEW).exceptionally(t -> {
            logger.error((Object)String.format("Failed build preview worker: %s", t.getMessage()), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletionStage<ExecutionStatus> rqProjectExecutionStatus() {
        return this.stareApi.getExecutionStatus("P").thenApply(any -> (ExecutionStatus)any.getData(ExecutionStatus.class).orElseThrow(() -> new RuntimeException("Failed get project execution status")));
    }

    static {
        iidStorage = IIDStorage.getInstance();
    }
}

