/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.CvArr;
import org.bytedeco.opencv.opencv_core.CvSparseMat;

@Properties(inherit={org.bytedeco.opencv.presets.opencv_core.class})
public abstract class AbstractCvSparseMat
extends CvArr {
    public AbstractCvSparseMat(Pointer p) {
        super(p);
    }

    public static CvSparseMat create(int dims, int[] sizes, int type) {
        CvSparseMat m = opencv_core.cvCreateSparseMat(dims, sizes, type);
        if (m != null) {
            m.deallocator(new ReleaseDeallocator(m));
        }
        return m;
    }

    public CvSparseMat clone() {
        CvSparseMat m = opencv_core.cvCloneSparseMat((CvSparseMat)this);
        if (m != null) {
            m.deallocator(new ReleaseDeallocator(m));
        }
        return m;
    }

    public void release() {
        this.deallocate();
    }

    protected static class ReleaseDeallocator
    extends CvSparseMat
    implements Pointer.Deallocator {
        ReleaseDeallocator(CvSparseMat p) {
            super(p);
        }

        public void deallocate() {
            if (this.isNull()) {
                return;
            }
            opencv_core.cvReleaseSparseMat(this);
            this.setNull();
        }
    }
}

