/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.conversions;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.opencv.common.VoidResultUMatFilter;
import net.algart.executors.modules.opencv.util.OTools;
import net.algart.executors.modules.opencv.util.enums.ODepth;
import net.algart.executors.modules.opencv.util.enums.ODepthOrUnchanged;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class ConvertPrecision
extends VoidResultUMatFilter
implements ReadOnlyExecutionInput {
    private ConvertMode convertMode = ConvertMode.AUTO;
    private ODepthOrUnchanged resultDepth = ODepthOrUnchanged.UNCHANGED;
    private double customAlpha = 1.0;
    private double customBeta = 0.0;

    public ConvertMode getConvertMode() {
        return this.convertMode;
    }

    public ConvertPrecision setConvertMode(ConvertMode convertMode) {
        this.convertMode = (ConvertMode)((Object)ConvertPrecision.nonNull((Object)((Object)convertMode)));
        return this;
    }

    public ODepthOrUnchanged getResultDepth() {
        return this.resultDepth;
    }

    public ConvertPrecision setResultDepth(ODepthOrUnchanged resultDepth) {
        this.resultDepth = (ODepthOrUnchanged)((Object)ConvertPrecision.nonNull((Object)((Object)resultDepth)));
        return this;
    }

    public double getCustomAlpha() {
        return this.customAlpha;
    }

    public ConvertPrecision setCustomAlpha(double customAlpha) {
        this.customAlpha = customAlpha;
        return this;
    }

    public double getCustomBeta() {
        return this.customBeta;
    }

    public ConvertPrecision setCustomBeta(double customBeta) {
        this.customBeta = customBeta;
        return this;
    }

    @Override
    public void process(Mat result, Mat source) {
        int resultDepthCode = this.resultDepth.code(source.depth());
        source.convertTo(result, resultDepthCode, this.alpha(source.depth()), this.beta(resultDepthCode));
    }

    @Override
    public void process(UMat result, UMat source) {
        int resultDepthCode = this.resultDepth.code(source.depth());
        source.convertTo(result, resultDepthCode, this.alpha(source.depth()), this.beta(resultDepthCode));
    }

    @Override
    protected boolean allowInputPackedBits() {
        return true;
    }

    private double alpha(int currentDepth) {
        switch (this.convertMode.ordinal()) {
            case 1: {
                return this.resultDepth == ODepthOrUnchanged.UNCHANGED ? 1.0 : this.resultDepth.maxValue() / ODepth.of(currentDepth).maxValue();
            }
            case 0: {
                return 1.0;
            }
            case 2: {
                return this.customAlpha;
            }
        }
        throw new AssertionError((Object)("Unsupported " + String.valueOf((Object)this.convertMode)));
    }

    private double beta(int resultDepth) {
        switch (this.convertMode.ordinal()) {
            case 0: 
            case 1: {
                return 0.0;
            }
            case 2: {
                return this.customBeta * OTools.maxPossibleValue(resultDepth);
            }
        }
        throw new AssertionError((Object)("Unsupported " + String.valueOf((Object)this.convertMode)));
    }

    public static enum ConvertMode {
        RAW,
        AUTO,
        CUSTOM;

    }
}

