/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.arithmetic;

import java.io.File;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.opencv.common.VoidResultTwoUMatFilter;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class Max
extends VoidResultTwoUMatFilter
implements ReadOnlyExecutionInput {
    @Override
    public void process(Mat result, Mat source, Mat secondMat) {
        opencv_core.max((Mat)source, (Mat)secondMat, (Mat)result);
    }

    @Override
    public void process(UMat result, UMat source, UMat secondMat) {
        opencv_core.max((UMat)source, (UMat)secondMat, (UMat)result);
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.printf("Usage: %s source_image_1 source_image_2 target_image%n", Max.class.getName());
            return;
        }
        File sourceFile1 = new File(args[0]);
        File sourceFile2 = new File(args[1]);
        File targetFile = new File(args[2]);
        Mat mat1 = opencv_imgcodecs.imread((String)sourceFile1.getPath());
        Mat mat2 = opencv_imgcodecs.imread((String)sourceFile2.getPath());
        Mat res = new Mat();
        new Max().process(res, mat1, mat2);
        opencv_imgcodecs.imwrite((String)targetFile.getPath(), (Mat)res);
    }
}

