/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsOfSquaresCalculator;

abstract class CardinalitiesAndSumsOfSquaresCalculator4Channels
extends CardinalitiesAndSumsOfSquaresCalculator {
    CardinalitiesAndSumsOfSquaresCalculator4Channels(int[] labels) {
        super(labels, 4);
    }

    static class ForDoubles
    extends CardinalitiesAndSumsOfSquaresCalculator4Channels {
        private final double[] data0;
        private final double[] data1;
        private final double[] data2;
        private final double[] data3;

        public ForDoubles(int[] labels, double[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            double[] sums2 = sums[2];
            double[] sums3 = sums[3];
            double[] sumsOfSquares0 = sumsOfSquares[0];
            double[] sumsOfSquares1 = sumsOfSquares[1];
            double[] sumsOfSquares2 = sumsOfSquares[2];
            double[] sumsOfSquares3 = sumsOfSquares[3];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForDoubles.ensureCapacityForLabel(cardinalities, label);
                    ForDoubles.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                    ForDoubles.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                    sums2 = sums[2];
                    sums3 = sums[3];
                    sumsOfSquares0 = sumsOfSquares[0];
                    sumsOfSquares1 = sumsOfSquares[1];
                    sumsOfSquares2 = sumsOfSquares[2];
                    sumsOfSquares3 = sumsOfSquares[3];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                double value0 = this.data0[k];
                double value1 = this.data1[k];
                double value2 = this.data2[k];
                double value3 = this.data3[k];
                int n2 = label;
                sums0[n2] = sums0[n2] + value0;
                int n3 = label;
                sums1[n3] = sums1[n3] + value1;
                int n4 = label;
                sums2[n4] = sums2[n4] + value2;
                int n5 = label;
                sums3[n5] = sums3[n5] + value3;
                int n6 = label;
                sumsOfSquares0[n6] = sumsOfSquares0[n6] + value0 * value0;
                int n7 = label;
                sumsOfSquares1[n7] = sumsOfSquares1[n7] + value1 * value1;
                int n8 = label;
                sumsOfSquares2[n8] = sumsOfSquares2[n8] + value2 * value2;
                int n9 = label;
                sumsOfSquares3[n9] = sumsOfSquares3[n9] + value3 * value3;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForFloats
    extends CardinalitiesAndSumsOfSquaresCalculator4Channels {
        private final float[] data0;
        private final float[] data1;
        private final float[] data2;
        private final float[] data3;

        public ForFloats(int[] labels, float[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            double[] sums2 = sums[2];
            double[] sums3 = sums[3];
            double[] sumsOfSquares0 = sumsOfSquares[0];
            double[] sumsOfSquares1 = sumsOfSquares[1];
            double[] sumsOfSquares2 = sumsOfSquares[2];
            double[] sumsOfSquares3 = sumsOfSquares[3];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForFloats.ensureCapacityForLabel(cardinalities, label);
                    ForFloats.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                    ForFloats.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                    sums2 = sums[2];
                    sums3 = sums[3];
                    sumsOfSquares0 = sumsOfSquares[0];
                    sumsOfSquares1 = sumsOfSquares[1];
                    sumsOfSquares2 = sumsOfSquares[2];
                    sumsOfSquares3 = sumsOfSquares[3];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                double value0 = this.data0[k];
                double value1 = this.data1[k];
                double value2 = this.data2[k];
                double value3 = this.data3[k];
                int n2 = label;
                sums0[n2] = sums0[n2] + value0;
                int n3 = label;
                sums1[n3] = sums1[n3] + value1;
                int n4 = label;
                sums2[n4] = sums2[n4] + value2;
                int n5 = label;
                sums3[n5] = sums3[n5] + value3;
                int n6 = label;
                sumsOfSquares0[n6] = sumsOfSquares0[n6] + value0 * value0;
                int n7 = label;
                sumsOfSquares1[n7] = sumsOfSquares1[n7] + value1 * value1;
                int n8 = label;
                sumsOfSquares2[n8] = sumsOfSquares2[n8] + value2 * value2;
                int n9 = label;
                sumsOfSquares3[n9] = sumsOfSquares3[n9] + value3 * value3;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForInts
    extends CardinalitiesAndSumsOfSquaresCalculator4Channels {
        private final int[] data0;
        private final int[] data1;
        private final int[] data2;
        private final int[] data3;

        public ForInts(int[] labels, int[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            double[] sums2 = sums[2];
            double[] sums3 = sums[3];
            double[] sumsOfSquares0 = sumsOfSquares[0];
            double[] sumsOfSquares1 = sumsOfSquares[1];
            double[] sumsOfSquares2 = sumsOfSquares[2];
            double[] sumsOfSquares3 = sumsOfSquares[3];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForInts.ensureCapacityForLabel(cardinalities, label);
                    ForInts.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                    ForInts.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                    sums2 = sums[2];
                    sums3 = sums[3];
                    sumsOfSquares0 = sumsOfSquares[0];
                    sumsOfSquares1 = sumsOfSquares[1];
                    sumsOfSquares2 = sumsOfSquares[2];
                    sumsOfSquares3 = sumsOfSquares[3];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                double value0 = this.data0[k];
                double value1 = this.data1[k];
                double value2 = this.data2[k];
                double value3 = this.data3[k];
                int n2 = label;
                sums0[n2] = sums0[n2] + value0;
                int n3 = label;
                sums1[n3] = sums1[n3] + value1;
                int n4 = label;
                sums2[n4] = sums2[n4] + value2;
                int n5 = label;
                sums3[n5] = sums3[n5] + value3;
                int n6 = label;
                sumsOfSquares0[n6] = sumsOfSquares0[n6] + value0 * value0;
                int n7 = label;
                sumsOfSquares1[n7] = sumsOfSquares1[n7] + value1 * value1;
                int n8 = label;
                sumsOfSquares2[n8] = sumsOfSquares2[n8] + value2 * value2;
                int n9 = label;
                sumsOfSquares3[n9] = sumsOfSquares3[n9] + value3 * value3;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForShorts
    extends CardinalitiesAndSumsOfSquaresCalculator4Channels {
        private final short[] data0;
        private final short[] data1;
        private final short[] data2;
        private final short[] data3;

        public ForShorts(int[] labels, short[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            double[] sums2 = sums[2];
            double[] sums3 = sums[3];
            double[] sumsOfSquares0 = sumsOfSquares[0];
            double[] sumsOfSquares1 = sumsOfSquares[1];
            double[] sumsOfSquares2 = sumsOfSquares[2];
            double[] sumsOfSquares3 = sumsOfSquares[3];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForShorts.ensureCapacityForLabel(cardinalities, label);
                    ForShorts.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                    ForShorts.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                    sums2 = sums[2];
                    sums3 = sums[3];
                    sumsOfSquares0 = sumsOfSquares[0];
                    sumsOfSquares1 = sumsOfSquares[1];
                    sumsOfSquares2 = sumsOfSquares[2];
                    sumsOfSquares3 = sumsOfSquares[3];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                double value0 = this.data0[k] & 0xFFFF;
                double value1 = this.data1[k] & 0xFFFF;
                double value2 = this.data2[k] & 0xFFFF;
                double value3 = this.data3[k] & 0xFFFF;
                int n2 = label;
                sums0[n2] = sums0[n2] + value0;
                int n3 = label;
                sums1[n3] = sums1[n3] + value1;
                int n4 = label;
                sums2[n4] = sums2[n4] + value2;
                int n5 = label;
                sums3[n5] = sums3[n5] + value3;
                int n6 = label;
                sumsOfSquares0[n6] = sumsOfSquares0[n6] + value0 * value0;
                int n7 = label;
                sumsOfSquares1[n7] = sumsOfSquares1[n7] + value1 * value1;
                int n8 = label;
                sumsOfSquares2[n8] = sumsOfSquares2[n8] + value2 * value2;
                int n9 = label;
                sumsOfSquares3[n9] = sumsOfSquares3[n9] + value3 * value3;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForBytes
    extends CardinalitiesAndSumsOfSquaresCalculator4Channels {
        private final byte[] data0;
        private final byte[] data1;
        private final byte[] data2;
        private final byte[] data3;

        public ForBytes(int[] labels, byte[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            double[] sums2 = sums[2];
            double[] sums3 = sums[3];
            double[] sumsOfSquares0 = sumsOfSquares[0];
            double[] sumsOfSquares1 = sumsOfSquares[1];
            double[] sumsOfSquares2 = sumsOfSquares[2];
            double[] sumsOfSquares3 = sumsOfSquares[3];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForBytes.ensureCapacityForLabel(cardinalities, label);
                    ForBytes.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                    ForBytes.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                    sums2 = sums[2];
                    sums3 = sums[3];
                    sumsOfSquares0 = sumsOfSquares[0];
                    sumsOfSquares1 = sumsOfSquares[1];
                    sumsOfSquares2 = sumsOfSquares[2];
                    sumsOfSquares3 = sumsOfSquares[3];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                double value0 = this.data0[k] & 0xFF;
                double value1 = this.data1[k] & 0xFF;
                double value2 = this.data2[k] & 0xFF;
                double value3 = this.data3[k] & 0xFF;
                int n2 = label;
                sums0[n2] = sums0[n2] + value0;
                int n3 = label;
                sums1[n3] = sums1[n3] + value1;
                int n4 = label;
                sums2[n4] = sums2[n4] + value2;
                int n5 = label;
                sums3[n5] = sums3[n5] + value3;
                int n6 = label;
                sumsOfSquares0[n6] = sumsOfSquares0[n6] + value0 * value0;
                int n7 = label;
                sumsOfSquares1[n7] = sumsOfSquares1[n7] + value1 * value1;
                int n8 = label;
                sumsOfSquares2[n8] = sumsOfSquares2[n8] + value2 * value2;
                int n9 = label;
                sumsOfSquares3[n9] = sumsOfSquares3[n9] + value3 * value3;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }
}

