/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsCalculator;

abstract class CardinalitiesAndSumsCalculator2Channels
extends CardinalitiesAndSumsCalculator {
    CardinalitiesAndSumsCalculator2Channels(int[] labels) {
        super(labels, 2);
    }

    static class ForDoubles
    extends CardinalitiesAndSumsCalculator2Channels {
        private final double[] data0;
        private final double[] data1;

        public ForDoubles(int[] labels, double[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForDoubles.ensureCapacityForLabel(cardinalities, label);
                    ForDoubles.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                int n2 = label;
                sums0[n2] = sums0[n2] + this.data0[k];
                int n3 = label;
                sums1[n3] = sums1[n3] + this.data1[k];
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForFloats
    extends CardinalitiesAndSumsCalculator2Channels {
        private final float[] data0;
        private final float[] data1;

        public ForFloats(int[] labels, float[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForFloats.ensureCapacityForLabel(cardinalities, label);
                    ForFloats.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                int n2 = label;
                sums0[n2] = sums0[n2] + (double)this.data0[k];
                int n3 = label;
                sums1[n3] = sums1[n3] + (double)this.data1[k];
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForInts
    extends CardinalitiesAndSumsCalculator2Channels {
        private final int[] data0;
        private final int[] data1;

        public ForInts(int[] labels, int[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForInts.ensureCapacityForLabel(cardinalities, label);
                    ForInts.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                int n2 = label;
                sums0[n2] = sums0[n2] + (double)this.data0[k];
                int n3 = label;
                sums1[n3] = sums1[n3] + (double)this.data1[k];
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForShorts
    extends CardinalitiesAndSumsCalculator2Channels {
        private final short[] data0;
        private final short[] data1;

        public ForShorts(int[] labels, short[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForShorts.ensureCapacityForLabel(cardinalities, label);
                    ForShorts.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                int n2 = label;
                sums0[n2] = sums0[n2] + (double)(this.data0[k] & 0xFFFF);
                int n3 = label;
                sums1[n3] = sums1[n3] + (double)(this.data1[k] & 0xFFFF);
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForBytes
    extends CardinalitiesAndSumsCalculator2Channels {
        private final byte[] data0;
        private final byte[] data1;

        public ForBytes(int[] labels, byte[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForBytes.ensureCapacityForLabel(cardinalities, label);
                    ForBytes.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                int n2 = label;
                sums0[n2] = sums0[n2] + (double)(this.data0[k] & 0xFF);
                int n3 = label;
                sums1[n3] = sums1[n3] + (double)(this.data1[k] & 0xFF);
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }
}

