/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsCalculator;

abstract class CardinalitiesAndSumsCalculator1Channels
extends CardinalitiesAndSumsCalculator {
    CardinalitiesAndSumsCalculator1Channels(int[] labels) {
        super(labels, 1);
    }

    static class ForDoubles
    extends CardinalitiesAndSumsCalculator1Channels {
        private final double[] data0;

        public ForDoubles(int[] labels, double[][] data) {
            super(labels);
            this.data0 = data[0];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[] sums0 = sums[0];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForDoubles.ensureCapacityForLabel(cardinalities, label);
                    ForDoubles.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                int n2 = label;
                sums0[n2] = sums0[n2] + this.data0[k];
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForFloats
    extends CardinalitiesAndSumsCalculator1Channels {
        private final float[] data0;

        public ForFloats(int[] labels, float[][] data) {
            super(labels);
            this.data0 = data[0];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[] sums0 = sums[0];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForFloats.ensureCapacityForLabel(cardinalities, label);
                    ForFloats.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                int n2 = label;
                sums0[n2] = sums0[n2] + (double)this.data0[k];
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForInts
    extends CardinalitiesAndSumsCalculator1Channels {
        private final int[] data0;

        public ForInts(int[] labels, int[][] data) {
            super(labels);
            this.data0 = data[0];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[] sums0 = sums[0];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForInts.ensureCapacityForLabel(cardinalities, label);
                    ForInts.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                int n2 = label;
                sums0[n2] = sums0[n2] + (double)this.data0[k];
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForShorts
    extends CardinalitiesAndSumsCalculator1Channels {
        private final short[] data0;

        public ForShorts(int[] labels, short[][] data) {
            super(labels);
            this.data0 = data[0];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[] sums0 = sums[0];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForShorts.ensureCapacityForLabel(cardinalities, label);
                    ForShorts.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                int n2 = label;
                sums0[n2] = sums0[n2] + (double)(this.data0[k] & 0xFFFF);
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForBytes
    extends CardinalitiesAndSumsCalculator1Channels {
        private final byte[] data0;

        public ForBytes(int[] labels, byte[][] data) {
            super(labels);
            this.data0 = data[0];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[] sums0 = sums[0];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForBytes.ensureCapacityForLabel(cardinalities, label);
                    ForBytes.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                int n2 = label;
                sums0[n2] = sums0[n2] + (double)(this.data0[k] & 0xFF);
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }
}

