/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.Objects;
import net.algart.arrays.AbstractBitArray;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.UpdatableBitArray;

class SwitchableBitMatrices {
    private final Matrix<? extends PFixedArray> objects;
    private final Matrix<? extends BitArray> bits;
    private final Matrix<UpdatableBitArray> buffer1;
    private final Matrix<UpdatableBitArray> buffer2;
    private final UpdatableBitArray buffer1Array;
    private final boolean binary;
    private int currentLabel = 0;

    public SwitchableBitMatrices(Matrix<? extends PFixedArray> objects, boolean needSecondBufferForBinary) {
        this.objects = Objects.requireNonNull(objects, "Null objects matrix");
        boolean bl = this.binary = objects.elementType() == Boolean.TYPE;
        if (this.binary) {
            this.bits = objects.cast(BitArray.class);
            this.buffer1 = Arrays.SMM.newBitMatrix(objects.dimensions());
            this.buffer2 = needSecondBufferForBinary ? Arrays.SMM.newBitMatrix(objects.dimensions()) : this.buffer1;
        } else {
            final PFixedArray objectsArray = (PFixedArray)objects.array();
            this.bits = objects.matrix((Array)new AbstractBitArray(objects.size(), true, new Array[0]){

                public boolean getBit(long index) {
                    return objectsArray.getInt(index) == SwitchableBitMatrices.this.currentLabel;
                }
            });
            this.buffer1 = Arrays.SMM.newBitMatrix(objects.dimensions());
            this.buffer2 = null;
        }
        this.buffer1Array = (UpdatableBitArray)this.buffer1.array();
    }

    public Matrix<? extends PFixedArray> objects() {
        return this.objects;
    }

    public Matrix<? extends BitArray> bits() {
        return this.bits;
    }

    public Matrix<UpdatableBitArray> buffer1() {
        return this.buffer1;
    }

    public Matrix<UpdatableBitArray> buffer2() {
        return this.buffer2;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public int getCurrentLabel() {
        return this.currentLabel;
    }

    public void setCurrentLabel(int currentLabel) {
        this.currentLabel = currentLabel;
    }

    public void setBuffer1Bit(long index) {
        this.buffer1Array.setBitNoSync(index);
    }
}

