/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary;

import java.util.Objects;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.MutableIntArray;
import net.algart.executors.modules.cv.matrices.misc.SortedRound2DAperture;
import net.algart.math.IPoint;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.matrices.morphology.BasicMorphology;
import net.algart.matrices.morphology.ContinuedMorphology;
import net.algart.matrices.morphology.Morphology;

public final class NearestPixelFinder {
    private static final Pattern CROSS_PATTERN = Patterns.newIntegerPattern((IPoint[])new IPoint[]{IPoint.of((long)0L, (long)0L), IPoint.of((long)1L, (long)0L), IPoint.of((long)0L, (long)1L), IPoint.of((long)-1L, (long)0L), IPoint.of((long)0L, (long)-1L)});
    private final boolean[] maskArray;
    private final boolean[] boundaries;
    private final int dimX;
    private final int dimY;
    private final SortedRound2DAperture maxAperture;
    private final SortedRound2DAperture neighbourhoodForNearest;
    private final int[] maxApertureOffsets;
    private final int[] maxApertureDx;
    private final int[] maxApertureDy;
    private final int[] neighbourhoodOffsets;
    private final int[] neighbourhoodDx;
    private final int[] neighbourhoodDy;
    private final int maxRadiusSum;
    private int maxNumberOfNeighbours = 1;
    private boolean skipPositionsAtMaks = true;

    public NearestPixelFinder(Matrix<? extends BitArray> mask, SortedRound2DAperture maxAperture, SortedRound2DAperture neighbourhoodForNearest) {
        Objects.requireNonNull(mask, "Null mask matrix");
        this.maskArray = ((BitArray)mask.array()).toJavaArray();
        this.maxAperture = Objects.requireNonNull(maxAperture);
        this.neighbourhoodForNearest = Objects.requireNonNull(neighbourhoodForNearest);
        if (!maxAperture.isSortedByIncreasingRadius()) {
            throw new IllegalArgumentException("maxAperture must be sorted by increasing radius");
        }
        this.maxApertureOffsets = maxAperture.offsets();
        this.maxApertureDx = maxAperture.dx();
        this.maxApertureDy = maxAperture.dy();
        this.neighbourhoodOffsets = neighbourhoodForNearest.offsets();
        this.neighbourhoodDx = neighbourhoodForNearest.dx();
        this.neighbourhoodDy = neighbourhoodForNearest.dy();
        this.maxRadiusSum = maxAperture.maxRadius() + neighbourhoodForNearest.maxRadius();
        ContinuedMorphology morphology = ContinuedMorphology.getInstance((Morphology)BasicMorphology.getInstance(null), (Matrix.ContinuationMode)Matrix.ContinuationMode.ZERO_CONSTANT);
        Matrix boundariesMatrix = morphology.erosion(mask, CROSS_PATTERN, Morphology.SubtractionMode.SUBTRACT_RESULT_FROM_SRC);
        this.boundaries = (boolean[])boundariesMatrix.toJavaArray();
        this.dimY = (int)mask.dimY();
        this.dimX = (int)mask.dimX();
        if (this.dimX != maxAperture.dimX()) {
            throw new IllegalArgumentException("maxAperture and mask matrix have different dimX");
        }
        if (this.dimX != neighbourhoodForNearest.dimX()) {
            throw new IllegalArgumentException("neighbourhoodForNearest and mask matrix have different dimX");
        }
    }

    public int getMaxNumberOfNeighbours() {
        return this.maxNumberOfNeighbours;
    }

    public NearestPixelFinder setMaxNumberOfNeighbours(int maxNumberOfNeighbours) {
        if (maxNumberOfNeighbours <= 0) {
            throw new IllegalArgumentException("Zero or negative maxNumberOfNeighbours");
        }
        this.maxNumberOfNeighbours = maxNumberOfNeighbours;
        return this;
    }

    public boolean isSkipPositionsAtMaks() {
        return this.skipPositionsAtMaks;
    }

    public NearestPixelFinder setSkipPositionsAtMaks(boolean skipPositionsAtMaks) {
        this.skipPositionsAtMaks = skipPositionsAtMaks;
        return this;
    }

    public int findNearest(int centerX, int centerY, MutableIntArray resultXY) {
        int dimX = this.dimX;
        int dimY = this.dimY;
        int centerIndex = centerY * dimX + centerX;
        int count = 0;
        if (this.maskArray[centerIndex]) {
            if (this.skipPositionsAtMaks) {
                return 0;
            }
            this.addPoint(centerX, centerY, resultXY);
            if (this.maxNumberOfNeighbours == 1) {
                return 1;
            }
            ++count;
        }
        if (centerX >= this.maxRadiusSum && centerX < dimX - this.maxRadiusSum && centerY >= this.maxRadiusSum && centerY < dimY - this.maxRadiusSum) {
            return this.quickCheckAperture(centerX, centerY, centerIndex, count, resultXY);
        }
        return this.checkAperture(centerX, centerY, centerIndex, count, resultXY);
    }

    private int quickCheckAperture(int centerX, int centerY, int centerIndex, int count, MutableIntArray resultXY) {
        int m = this.maxAperture.count();
        int n = this.neighbourhoodForNearest.count();
        block0: for (int k = 0; k < m; ++k) {
            int indexProbe = centerIndex + this.maxApertureOffsets[k];
            if (!this.boundaries[indexProbe]) continue;
            int dxProbe = this.maxApertureDx[k];
            int dyProbe = this.maxApertureDy[k];
            int dProbe = this.maxAperture.hypotSqr(k);
            for (int j = 0; j < n; ++j) {
                int dy;
                int dx;
                int d;
                int index = indexProbe + this.neighbourhoodOffsets[j];
                if (this.maskArray[index] && ((d = (dx = dxProbe + this.neighbourhoodDx[j]) * dx + (dy = dyProbe + this.neighbourhoodDy[j]) * dy) < dProbe || d == dProbe && (dy < dyProbe || dy == dyProbe && dx < dxProbe))) continue block0;
            }
            this.addPoint(centerX + dxProbe, centerY + dyProbe, resultXY);
            if (++count < this.maxNumberOfNeighbours) continue;
            return count;
        }
        return count;
    }

    private int checkAperture(int centerX, int centerY, int centerIndex, int count, MutableIntArray resultXY) {
        int m = this.maxAperture.count();
        int n = this.neighbourhoodForNearest.count();
        block0: for (int k = 0; k < m; ++k) {
            int xProbe = centerX + this.maxApertureDx[k];
            int yProbe = centerY + this.maxApertureDy[k];
            if (xProbe < 0 || yProbe < 0 || xProbe >= this.dimX || yProbe >= this.dimY) continue;
            int indexProbe = centerIndex + this.maxApertureOffsets[k];
            assert (indexProbe >= 0) : indexProbe + "center " + centerX + ", " + centerY + ", point=" + xProbe + ", " + yProbe + " at " + k;
            if (!this.boundaries[indexProbe]) continue;
            int dProbe = this.maxAperture.hypotSqr(k);
            for (int j = 0; j < n; ++j) {
                int dy;
                int dx;
                int d;
                int index;
                int x = xProbe + this.neighbourhoodDx[j];
                int y = yProbe + this.neighbourhoodDy[j];
                if (x >= 0 && y >= 0 && x < this.dimX && y < this.dimY && this.maskArray[index = indexProbe + this.neighbourhoodOffsets[j]] && ((d = (dx = x - centerX) * dx + (dy = y - centerY) * dy) < dProbe || d == dProbe && (y < yProbe || y == yProbe && x < xProbe))) continue block0;
            }
            this.addPoint(xProbe, yProbe, resultXY);
            if (++count < this.maxNumberOfNeighbours) continue;
            return count;
        }
        return count;
    }

    private void addPoint(int nearestX, int nearestY, MutableIntArray resultXY) {
        resultXY.addInt(nearestX);
        resultXY.addInt(nearestY);
    }
}

