/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.SMat;

public class SMatUtils {
    public static double[] getPixelValue(Data data, int x, int y) {
        if (data == null) {
            return null;
        }
        if (!SMat.class.isAssignableFrom(data.getClass())) {
            return null;
        }
        SMat sMat = (SMat)data;
        long dimX = sMat.getDimX();
        long dimY = sMat.getDimY();
        if (0 > x || (long)x >= dimX || 0 > y || (long)y >= dimY) {
            return null;
        }
        int channels = sMat.getNumberOfChannels();
        int address = (int)((long)channels * (dimX * (long)y + (long)x));
        boolean swapChannels = channels == 3 || channels == 4;
        ByteBuffer bb = sMat.getByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
        double[] value = new double[channels];
        switch (sMat.getDepth()) {
            case BIT: {
                int bitOffset = address % 8;
                byte currentByte = bb.get(address /= 8);
                int mask = 1 << bitOffset;
                int vall = currentByte & mask;
                value[0] = vall > 0 ? 1.0 : 0.0;
                break;
            }
            case U8: {
                for (int i = 0; i < channels; ++i) {
                    int val = bb.get(address + i) & 0xFF;
                    value[i] = val;
                }
                break;
            }
            case S8: {
                for (int i = 0; i < channels; ++i) {
                    byte val = bb.get(address + i);
                    value[i] = val;
                }
                break;
            }
            case U16: {
                for (int i = 0; i < channels; ++i) {
                    int val = bb.getShort((address + i) * 2) & 0xFFFF;
                    value[i] = val;
                }
                break;
            }
            case S16: {
                for (int i = 0; i < channels; ++i) {
                    short val = bb.getShort((address + i) * 2);
                    value[i] = val;
                }
                break;
            }
            case F32: {
                for (int i = 0; i < channels; ++i) {
                    float val = bb.getFloat((address + i) * 4);
                    value[i] = val;
                }
                break;
            }
            case S32: {
                for (int i = 0; i < channels; ++i) {
                    int val = bb.getInt((address + i) * 4);
                    value[i] = val;
                }
                break;
            }
            case F64: {
                for (int i = 0; i < channels; ++i) {
                    value[i] = bb.getDouble((address + i) * 8);
                }
                break;
            }
        }
        if (swapChannels) {
            double v0 = value[0];
            value[0] = value[2];
            value[2] = v0;
        }
        return value;
    }
}

