/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.utils;

import javafx.geometry.Point2D;

public class Rect {
    protected double x;
    protected double y;
    protected double width;
    protected double height;

    public Rect() {
        this.x = 0.0;
        this.y = 0.0;
        this.width = 0.0;
        this.height = 0.0;
    }

    public Rect(double x, double y, double width, double height) {
        this.set(x, y, width, height);
    }

    public void set(double x, double y, double width, double height) {
        assert (width >= 0.0);
        assert (height >= 0.0);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void set(Rect rect) {
        this.x = rect.getX();
        this.y = rect.getY();
        this.width = rect.getWidth();
        this.height = rect.getHeight();
    }

    public void setSize(double width, double height) {
        assert (width >= 0.0);
        assert (height >= 0.0);
        this.width = width;
        this.height = height;
    }

    public double getX() {
        return this.x;
    }

    public boolean setX(double x) {
        boolean ne = Double.doubleToLongBits(this.x) != Double.doubleToLongBits(x);
        this.x = x;
        return ne;
    }

    public double getY() {
        return this.y;
    }

    public boolean setY(double y) {
        boolean ne = Double.doubleToLongBits(this.y) != Double.doubleToLongBits(y);
        this.y = y;
        return ne;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getX2() {
        return this.x + this.width - 1.0;
    }

    public double getY2() {
        return this.y + this.height - 1.0;
    }

    public String toString() {
        return String.format("x = %.1f, y = %.1f, width = %.1f, height = %.1f, cx = %.1f, cy = %.1f", this.x, this.y, this.width, this.height, this.x + this.width * 0.5, this.y + this.height * 0.5);
    }

    public Rect copy() {
        return new Rect(this.x, this.y, this.width, this.height);
    }

    public void copyTo(Rect rect) {
        rect.set(this.x, this.y, this.width, this.height);
    }

    public boolean inBound(double testX, double testY) {
        return this.x <= testX && testX < this.width && this.y <= testY && testY < this.height;
    }

    public Point2D upperLeft() {
        return new Point2D(this.x, this.y);
    }

    public Point2D bottomRight() {
        return new Point2D(this.getX2(), this.getY2());
    }

    public Point2D center() {
        return new Point2D(this.x + 0.5 * this.width, this.y + 0.5 * this.height);
    }

    public Rect intersect(Rect other) {
        double commonHeight;
        Rect vr2;
        Rect vr1 = this.x < other.x ? this : other;
        Rect rect = vr2 = this.x < other.x ? other : this;
        if (vr1.getX2() <= vr2.x) {
            return new Rect();
        }
        double cX = vr2.x;
        double commonWidth = vr1.getX2() < vr2.getX2() ? vr1.getX2() - vr2.x : vr2.width;
        vr1 = this.y < other.y ? this : other;
        Rect rect2 = vr2 = this.y < other.y ? other : this;
        if (vr1.getY2() <= vr2.y) {
            return new Rect();
        }
        double cY = vr2.y;
        double d = commonHeight = vr1.getY2() < vr2.getY2() ? vr1.getY2() - vr2.y : vr2.height;
        if (commonWidth <= 0.0 || commonHeight <= 0.0) {
            return new Rect();
        }
        return new Rect(cX, cY, commonWidth, commonHeight);
    }
}

