/*
 * Decompiled with CFR 0.152.
 */
package com.siams.javafx.spinner;

import java.math.BigDecimal;
import javafx.beans.NamedArg;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.control.SpinnerValueFactory;
import javafx.util.StringConverter;

public final class DoubleSpinnerValueFactory
extends SpinnerValueFactory<Double> {
    private DoubleProperty min = new SimpleDoubleProperty((Object)this, "min"){

        protected void invalidated() {
            Double currentValue = this.getValue();
            if (currentValue == null) {
                return;
            }
            double newMin = this.get();
            if (newMin > DoubleSpinnerValueFactory.this.getMax()) {
                DoubleSpinnerValueFactory.this.setMin(DoubleSpinnerValueFactory.this.getMax());
                return;
            }
            if (currentValue < newMin) {
                this.setValue(newMin);
            }
        }
    };
    private DoubleProperty max = new SimpleDoubleProperty((Object)this, "max"){

        protected void invalidated() {
            Double currentValue = this.getValue();
            if (currentValue == null) {
                return;
            }
            double newMax = this.get();
            if (newMax < DoubleSpinnerValueFactory.this.getMin()) {
                DoubleSpinnerValueFactory.this.setMax(DoubleSpinnerValueFactory.this.getMin());
                return;
            }
            if (currentValue > newMax) {
                this.setValue(newMax);
            }
        }
    };
    private DoubleProperty amountToStepBy = new SimpleDoubleProperty((Object)this, "amountToStepBy");

    public DoubleSpinnerValueFactory(@NamedArg(value="min") double min, @NamedArg(value="max") double max) {
        this(min, max, min);
    }

    public DoubleSpinnerValueFactory(@NamedArg(value="min") double min, @NamedArg(value="max") double max, @NamedArg(value="initialValue") double initialValue) {
        this(min, max, initialValue, 1.0);
    }

    public DoubleSpinnerValueFactory(@NamedArg(value="min") double min, @NamedArg(value="max") double max, @NamedArg(value="initialValue") double initialValue, @NamedArg(value="amountToStepBy") double amountToStepBy) {
        this.setMin(min);
        this.setMax(max);
        this.setAmountToStepBy(amountToStepBy);
        this.setConverter((StringConverter)new StringConverter<Double>(this){

            public String toString(Double value) {
                if (value == null) {
                    return "";
                }
                return String.valueOf(value);
            }

            public Double fromString(String value) {
                try {
                    if (value == null) {
                        return null;
                    }
                    if ((value = value.trim()).length() < 1) {
                        return null;
                    }
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        this.valueProperty().addListener((o, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            if (newValue < this.getMin()) {
                this.setValue(this.getMin());
            } else if (newValue > this.getMax()) {
                this.setValue(this.getMax());
            }
        });
        this.setValue(initialValue >= min && initialValue <= max ? initialValue : min);
    }

    public final void setMin(double value) {
        this.min.set(value);
    }

    public final double getMin() {
        return this.min.get();
    }

    public final DoubleProperty minProperty() {
        return this.min;
    }

    public final void setMax(double value) {
        this.max.set(value);
    }

    public final double getMax() {
        return this.max.get();
    }

    public final DoubleProperty maxProperty() {
        return this.max;
    }

    public final void setAmountToStepBy(double value) {
        this.amountToStepBy.set(value);
    }

    public final double getAmountToStepBy() {
        return this.amountToStepBy.get();
    }

    public final DoubleProperty amountToStepByProperty() {
        return this.amountToStepBy;
    }

    public void decrement(int steps) {
        BigDecimal currentValue = BigDecimal.valueOf((Double)this.getValue());
        BigDecimal minBigDecimal = BigDecimal.valueOf(this.getMin());
        BigDecimal maxBigDecimal = BigDecimal.valueOf(this.getMax());
        BigDecimal amountToStepByBigDecimal = BigDecimal.valueOf(this.getAmountToStepBy());
        BigDecimal newValue = currentValue.subtract(amountToStepByBigDecimal.multiply(BigDecimal.valueOf(steps)));
        this.setValue(newValue.compareTo(minBigDecimal) >= 0 ? newValue.doubleValue() : (this.isWrapAround() ? DoubleSpinnerValueFactory.wrapValue(newValue, minBigDecimal, maxBigDecimal).doubleValue() : this.getMin()));
    }

    public void increment(int steps) {
        BigDecimal currentValue = BigDecimal.valueOf((Double)this.getValue());
        BigDecimal minBigDecimal = BigDecimal.valueOf(this.getMin());
        BigDecimal maxBigDecimal = BigDecimal.valueOf(this.getMax());
        BigDecimal amountToStepByBigDecimal = BigDecimal.valueOf(this.getAmountToStepBy());
        BigDecimal newValue = currentValue.add(amountToStepByBigDecimal.multiply(BigDecimal.valueOf(steps)));
        this.setValue(newValue.compareTo(maxBigDecimal) <= 0 ? newValue.doubleValue() : (this.isWrapAround() ? DoubleSpinnerValueFactory.wrapValue(newValue, minBigDecimal, maxBigDecimal).doubleValue() : this.getMax()));
    }

    static BigDecimal wrapValue(BigDecimal value, BigDecimal min, BigDecimal max) {
        if (max.doubleValue() == 0.0) {
            throw new RuntimeException();
        }
        if (value.compareTo(min) < 0) {
            return max;
        }
        if (value.compareTo(max) > 0) {
            return min;
        }
        return value;
    }
}

