/*
 * Decompiled with CFR 0.152.
 */
package com.siams.javafx;

import com.siams.notifications.StareNotification;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Accordion;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import org.apache.log4j.Logger;

public class GUIUtils {
    private static Method columnToFitMethod;
    private static Logger logger;

    public static <T> void handleFutureException(CompletableFuture<T> future) {
        future.whenComplete((o, t) -> {
            if (t != null) {
                logger.error((Object)t.getMessage(), t);
                StareNotification.showWarn(t.getMessage());
            }
        });
    }

    @Deprecated
    public static <T> T lookup(Parent parent, String selector) {
        Node node = parent.lookup(selector);
        if (node == null && selector.startsWith("#")) {
            return GUIUtils.getChildByID(parent, selector.substring(1));
        }
        return (T)node;
    }

    public static <T> T getChildByID(Parent parent, String id) {
        T child;
        T child2;
        String nodeId;
        String pId = parent.getId();
        if (pId != null && pId.equals(id)) {
            return (T)parent;
        }
        if (parent instanceof TitledPane) {
            TitledPane titledPane = (TitledPane)parent;
            Node content = titledPane.getContent();
            nodeId = (String)content.idProperty().get();
            if (nodeId != null && nodeId.equals(id)) {
                return (T)content;
            }
            if (content instanceof Parent && (child2 = GUIUtils.getChildByID((Parent)content, id)) != null) {
                return child2;
            }
        } else if (parent instanceof MenuButton) {
            MenuButton menuButton = (MenuButton)parent;
            for (MenuItem item : menuButton.getItems()) {
                String nodeId2 = item.getId();
                if (nodeId2 == null || !nodeId2.equals(id)) continue;
                return (T)item;
            }
        } else if (parent instanceof BorderPane) {
            T child3;
            BorderPane borderPane = (BorderPane)parent;
            Node top = borderPane.getTop();
            if (top != null && Parent.class.isAssignableFrom(top.getClass()) && (child = GUIUtils.getChildByID((Parent)top, id)) != null) {
                return child;
            }
            Node left = borderPane.getLeft();
            if (left != null && Parent.class.isAssignableFrom(left.getClass()) && (child2 = GUIUtils.getChildByID((Parent)left, id)) != null) {
                return child2;
            }
            Node right = borderPane.getLeft();
            if (right != null && Parent.class.isAssignableFrom(right.getClass()) && (child = GUIUtils.getChildByID((Parent)right, id)) != null) {
                return child;
            }
            Node center = borderPane.getLeft();
            if (center != null && Parent.class.isAssignableFrom(center.getClass()) && (child3 = GUIUtils.getChildByID((Parent)center, id)) != null) {
                return child3;
            }
            Node bottom = borderPane.getLeft();
            if (bottom != null && Parent.class.isAssignableFrom(bottom.getClass()) && (child = GUIUtils.getChildByID((Parent)bottom, id)) != null) {
                return child;
            }
        } else if (ButtonBase.class.isAssignableFrom(parent.getClass())) {
            ButtonBase buttonBase = (ButtonBase)parent;
            String nodeId3 = buttonBase.getId();
            if (nodeId3 != null && nodeId3.equals(id)) {
                return (T)buttonBase;
            }
        } else if (parent instanceof ScrollPane) {
            ScrollPane scrollPane = (ScrollPane)parent;
            String parentId = scrollPane.getId();
            if (parentId != null && parentId.equals(id)) {
                return (T)scrollPane;
            }
            child = GUIUtils.getChildByID((Parent)scrollPane.getContent(), id);
            if (child != null) {
                return child;
            }
        } else if (parent instanceof ToolBar) {
            ToolBar toolBar = (ToolBar)parent;
            for (Node node : toolBar.getItems()) {
                if (!Parent.class.isAssignableFrom(node.getClass())) continue;
                Parent item = (Parent)node;
                if (item.getId() != null && item.getId().equals(id)) {
                    return (T)item;
                }
                child = GUIUtils.getChildByID(parent, id);
                if (child == null) continue;
                return child;
            }
        }
        for (Node node : parent.getChildrenUnmodifiable()) {
            nodeId = (String)node.idProperty().get();
            if (nodeId != null && nodeId.equals(id)) {
                return (T)node;
            }
            if (node instanceof SplitPane) {
                SplitPane splitPane = (SplitPane)node;
                for (Node itemNode : splitPane.getItems()) {
                    nodeId = (String)itemNode.idProperty().get();
                    if (nodeId != null && nodeId.equals(id)) {
                        return (T)itemNode;
                    }
                    if (!(itemNode instanceof Parent) || (child = GUIUtils.getChildByID((Parent)itemNode, id)) == null) continue;
                    return child;
                }
                continue;
            }
            if (node instanceof Accordion) {
                Accordion accordion = (Accordion)node;
                for (TitledPane titledPane : accordion.getPanes()) {
                    nodeId = (String)titledPane.idProperty().get();
                    if (nodeId != null && nodeId.equals(id)) {
                        return (T)titledPane;
                    }
                    child = GUIUtils.getChildByID((Parent)titledPane, id);
                    if (child == null) continue;
                    return child;
                }
                continue;
            }
            if (node instanceof MenuBar) {
                MenuBar menuBar = (MenuBar)node;
                for (Menu menu : menuBar.getMenus()) {
                    String menuId = menu.getId();
                    if (menuId != null && menuId.equals(id)) {
                        return (T)menu;
                    }
                    for (MenuItem menuItem : menu.getItems()) {
                        String menuItemId = menuItem.getId();
                        if (menuItemId == null || !menuItemId.equals(id)) continue;
                        return (T)menuItem;
                    }
                }
                continue;
            }
            if (node instanceof ToolBar) {
                ToolBar toolBar = (ToolBar)node;
                for (Node item : toolBar.getItems()) {
                    nodeId = item.getId();
                    if (nodeId != null && nodeId.equals(id)) {
                        return (T)item;
                    }
                    if (!Parent.class.isAssignableFrom(item.getClass()) || (child = GUIUtils.getChildByID((Parent)item, id)) == null) continue;
                    return child;
                }
                continue;
            }
            if (!(node instanceof Parent) || (child2 = GUIUtils.getChildByID((Parent)node, id)) == null) continue;
            return child2;
        }
        return null;
    }

    static {
        logger = Logger.getLogger(GUIUtils.class);
    }
}

