/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.grpc;

import com.siams.stare.api.Any;
import com.siams.stare.api.data.Control;
import com.siams.stare.api.data.ErrorInfo;
import com.siams.stare.api.data.Port;
import com.siams.stare.api.data.SolutionApp;
import com.siams.stare.api.data.SolutionTemplate;
import com.siams.stare.api.data.ValueType;
import com.siams.stare.api.data.setting.Setting;
import com.siams.stare.api.data.worker.ExecutionStatus;
import com.siams.stare.api.data.worker.Model;
import com.siams.stare.api.data.worker.Worker;
import com.siams.stare.grpc.ResponseConverter;
import com.siams.stare.grpc.message.datatype.GAnyData;
import com.siams.stare.grpc.message.datatype.GControl;
import com.siams.stare.grpc.message.datatype.GElementType;
import com.siams.stare.grpc.message.datatype.GErrorInfo;
import com.siams.stare.grpc.message.datatype.GExecutionStatus;
import com.siams.stare.grpc.message.datatype.GMat;
import com.siams.stare.grpc.message.datatype.GModel;
import com.siams.stare.grpc.message.datatype.GNumbers;
import com.siams.stare.grpc.message.datatype.GPort;
import com.siams.stare.grpc.message.datatype.GSettingNode;
import com.siams.stare.grpc.message.datatype.GSolutionApp;
import com.siams.stare.grpc.message.datatype.GSolutionTemplate;
import com.siams.stare.grpc.message.datatype.GWorker;
import com.siams.stare.grpc.message.rqrs2.GetDataResponse;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;

class GetDataConverter
implements ResponseConverter<GetDataResponse, Any> {
    private static Logger logger = Logger.getLogger(GetDataConverter.class.getName());

    GetDataConverter() {
    }

    private static Any convertBaseTypes(GAnyData gAnyData) {
        String url = gAnyData.getUrl();
        switch (gAnyData.getValueCase()) {
            case BOOL_VAL: {
                return new Any(url, (Object)gAnyData.getBoolVal());
            }
            case INT32_VAL: {
                return new Any(url, (Object)gAnyData.getInt32Val());
            }
            case DOUBLE_VAL: {
                return new Any(url, (Object)gAnyData.getDoubleVal());
            }
            case STRING_VAL: {
                return new Any(url, (Object)gAnyData.getStringVal());
            }
            case INT64_VAL: {
                return new Any(url, (Object)gAnyData.getInt64Val());
            }
        }
        return null;
    }

    private static Any convertNumbers(GAnyData gAnyData) {
        String url = gAnyData.getUrl();
        GNumbers gNumbers = gAnyData.getNumbers();
        int blockLength = gNumbers.getBlockLength();
        GElementType gElementType = gNumbers.getElementType();
        Any result = new Any(url, null, gAnyData.getModified());
        if (blockLength == 0 || gElementType == GElementType.kUnknown || gElementType == GElementType.UNRECOGNIZED) {
            result = new Any(url, (Object)DataType.NUMBERS.createEmpty());
        } else {
            ByteBuffer numbersBuffer = gNumbers.getBuffer().asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
            switch (gElementType) {
                case kUnknown: {
                    break;
                }
                case kByte: {
                    int size = numbersBuffer.capacity();
                    byte[] array = new byte[size];
                    for (int i = 0; i < size; ++i) {
                        array[i] = numbersBuffer.get();
                    }
                    result = new Any(url, (Object)SNumbers.ofArray((Object)array, (int)blockLength));
                    break;
                }
                case kShort: {
                    int size = numbersBuffer.capacity() / 2;
                    short[] array = new short[size];
                    for (int i = 0; i < size; ++i) {
                        array[i] = numbersBuffer.getShort();
                    }
                    result = new Any(url, (Object)SNumbers.ofArray((Object)array, (int)blockLength));
                    break;
                }
                case kInt32: {
                    int size = numbersBuffer.capacity() / 4;
                    int[] array = new int[size];
                    for (int i = 0; i < size; ++i) {
                        array[i] = numbersBuffer.getInt();
                    }
                    result = new Any(url, (Object)SNumbers.ofArray((Object)array, (int)blockLength));
                    break;
                }
                case kInt64: {
                    int size = numbersBuffer.capacity() / 8;
                    long[] array = new long[size];
                    for (int i = 0; i < size; ++i) {
                        array[i] = numbersBuffer.getLong();
                    }
                    result = new Any(url, (Object)SNumbers.ofArray((Object)array, (int)blockLength));
                    break;
                }
                case kFloat: {
                    int size = numbersBuffer.capacity() / 4;
                    float[] array = new float[size];
                    for (int i = 0; i < size; ++i) {
                        array[i] = numbersBuffer.getFloat();
                    }
                    result = new Any(url, (Object)SNumbers.ofArray((Object)array, (int)blockLength));
                    break;
                }
                case kDouble: {
                    int size = numbersBuffer.capacity() / 8;
                    double[] array = new double[size];
                    for (int i = 0; i < size; ++i) {
                        array[i] = numbersBuffer.getDouble();
                    }
                    result = new Any(url, (Object)SNumbers.ofArray((Object)array, (int)blockLength));
                    break;
                }
            }
        }
        return result;
    }

    private static Any convertBuffer(GAnyData gAnyData) {
        String url = gAnyData.getUrl();
        ByteBuffer buffer = gAnyData.getBuffer().asReadOnlyByteBuffer();
        ByteOrder byteOrder = buffer.order();
        ByteBuffer duplicate = buffer.duplicate();
        ByteBuffer resultBuffer = duplicate.isDirect() ? ByteBuffer.allocateDirect(duplicate.capacity()) : ByteBuffer.allocate(duplicate.capacity());
        resultBuffer.order(byteOrder);
        buffer.rewind();
        resultBuffer.put(duplicate);
        resultBuffer.rewind();
        return new Any(url, (Object)resultBuffer);
    }

    private static Any convertScalar(GAnyData gAnyData) {
        String url = gAnyData.getUrl();
        return new Any(url, (Object)SScalar.of((Object)gAnyData.getScalar().getValue()), gAnyData.getModified());
    }

    private static Any convertMat(GAnyData gAnyData) {
        String url = gAnyData.getUrl();
        Any result = new Any(url, null, gAnyData.getModified());
        GMat gMat = gAnyData.getMat();
        String encoded = gMat.getEncoded();
        long[] dims = new long[gMat.getDimsCount()];
        for (int i = 0; i < gMat.getDimsCount(); ++i) {
            dims[i] = gMat.getDims(i);
        }
        int channels = gMat.getChannels();
        int depth = gMat.getDepthValue();
        ByteBuffer matBuffer = gMat.getBuffer().asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
        if (dims.length != 0 && encoded.isEmpty()) {
            result = new Any(url, (Object)SMat.of((long[])dims, (SMat.Depth)SMat.Depth.of((int)depth), (int)channels, (ByteBuffer)matBuffer));
        } else if (encoded.equalsIgnoreCase("jpeg") || encoded.equalsIgnoreCase("jpg")) {
            try {
                int size = matBuffer.capacity();
                byte[] array = new byte[size];
                for (int i = 0; i < size; ++i) {
                    array[i] = matBuffer.get();
                }
                ByteArrayInputStream in = new ByteArrayInputStream(array);
                result = new Any(url, (Object)ImageIO.read(in));
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Failed created buffered image from encoded GMat", t);
            }
        } else {
            result = new Any(url, (Object)DataType.MAT.createEmpty());
        }
        return result;
    }

    private static Port createPort(GPort gPort) {
        Port port = new Port();
        port.id = gPort.getId();
        port.name = gPort.getName();
        port.caption = gPort.getCaption();
        port.dataType = ValueType.from((String)gPort.getDataType());
        port.hint = gPort.getHint();
        port.type = Port.Type.from((int)gPort.getPortKind().getNumber());
        port.advanced = gPort.getAdvanced();
        return port;
    }

    private static Control createControl(GControl gControl) {
        Control control = new Control();
        control.multiline = gControl.getMultiline();
        control.editionRows = gControl.getEditionRows();
        control.name = gControl.getName();
        control.valueType = ValueType.from((String)gControl.getValueType());
        control.caption = gControl.getCaption();
        control.def = gControl.getDef();
        control.editionType = Control.EditionType.from((String)gControl.getEditionType());
        control.hint = gControl.getHint();
        control.description = gControl.getDescription();
        control.id = gControl.getId();
        control.url = gControl.getUrl();
        control.isResource = gControl.getIsResource();
        control.dialog = Control.FileDialog.from((int)gControl.getDialog().getNumber());
        control.isAdvanced = gControl.getIsAdvanced();
        control.items = gControl.getItemsList().stream().map(gItem -> {
            Control.Item item = new Control.Item();
            item.caption = gItem.getCaption();
            item.value = gItem.getValue();
            return item;
        }).collect(Collectors.toList());
        return control;
    }

    private static Any convertSetting(GAnyData gAnyData) {
        String url = gAnyData.getUrl();
        GSettingNode gSettingNode = gAnyData.getSettingNode();
        Setting setting = new Setting();
        setting.url = url;
        setting.id = gSettingNode.getId();
        setting.parentId = gSettingNode.getParentId();
        setting.name = gSettingNode.getName();
        setting.description = gSettingNode.getDescription();
        setting.controls = gSettingNode.getControlsList().stream().map(GetDataConverter::createControl).collect(Collectors.toList());
        return new Any(url, (Object)setting);
    }

    private static Model createModel(GModel gModel) {
        Model model = new Model();
        model.id = gModel.getId();
        model.name = gModel.getName();
        model.category = gModel.getCategory();
        model.language.name = gModel.getLanguage();
        model.language.details = gModel.getLanguageDetails();
        model.description = gModel.getDescription();
        model.tags = new HashSet(gModel.getTagsList());
        gModel.getOptionalList().forEach(optional -> model.addOptional(Model.Optional.from((int)optional)));
        model.controls = gModel.getControlsList().stream().map(GetDataConverter::createControl).collect(Collectors.toList());
        model.ports = gModel.getPortsList().stream().map(GetDataConverter::createPort).collect(Collectors.toList());
        model.roleName = gModel.getRoleName();
        model.executionStage = Model.ExecutionStage.from((int)gModel.getExecutionStageValue());
        model.tmp_json = gModel.getTmpJson();
        return model;
    }

    private static Any convertWorker(GAnyData gAnyData) {
        String url = gAnyData.getUrl();
        GWorker gWorker = gAnyData.getWorker();
        Worker worker = new Worker();
        worker.id = gWorker.getId();
        worker.url = url;
        worker.name = gWorker.getName();
        worker.systemName = gWorker.getSystemName();
        worker.resultInfo = gWorker.getResultInfo();
        worker.model = GetDataConverter.createModel(gWorker.getModel());
        worker.ports = gWorker.getPortsList().stream().map(GetDataConverter::createPort).collect(Collectors.toList());
        worker.tmp_json = gWorker.getTmpJson();
        return new Any(url, (Object)worker);
    }

    private static Any convertModel(GAnyData gAnyData) {
        String url = gAnyData.getUrl();
        GModel gModel = gAnyData.getModel();
        return new Any(url, (Object)GetDataConverter.createModel(gModel));
    }

    private static ExecutionStatus createExecutionStatus(GExecutionStatus gStatus) {
        return new ExecutionStatus(gStatus.getFull(), gStatus.getInformation(), gStatus.getMessages(), gStatus.getComments(), gStatus.getJson(), gStatus.getCustomJson());
    }

    private static Any convertExecutionStatus(GAnyData gAnyData) {
        return new Any(gAnyData.getUrl(), (Object)GetDataConverter.createExecutionStatus(gAnyData.getExecutionStatus()));
    }

    private static Any convertErrorInfo(GAnyData gAnyData) {
        String url = gAnyData.getUrl();
        GErrorInfo gErrorInfo = gAnyData.getErrorInfo();
        ErrorInfo errorInfo = new ErrorInfo();
        errorInfo.error_message = gErrorInfo.getErrorMessage();
        errorInfo.stack_trace = gErrorInfo.getStackTrace();
        errorInfo.error_class_name = gErrorInfo.getErrorClassName();
        return new Any(url, (Object)errorInfo);
    }

    static Any convert(GAnyData gAnyData) {
        String url = gAnyData.getUrl();
        Any result = new Any(url, null, gAnyData.getModified());
        switch (gAnyData.getValueCase()) {
            case BOOL_VAL: 
            case INT32_VAL: 
            case DOUBLE_VAL: 
            case STRING_VAL: 
            case INT64_VAL: {
                result = GetDataConverter.convertBaseTypes(gAnyData);
                assert (result != null);
                break;
            }
            case NUMBERS: {
                result = GetDataConverter.convertNumbers(gAnyData);
                break;
            }
            case BUFFER: {
                result = GetDataConverter.convertBuffer(gAnyData);
                break;
            }
            case MAT: {
                result = GetDataConverter.convertMat(gAnyData);
                break;
            }
            case SCALAR: {
                result = GetDataConverter.convertScalar(gAnyData);
                break;
            }
            case SETTING_NODE: {
                result = GetDataConverter.convertSetting(gAnyData);
                break;
            }
            case WORKER: {
                result = GetDataConverter.convertWorker(gAnyData);
                break;
            }
            case VALUE_NOT_SET: {
                break;
            }
            case SOLUTION: {
                result = GetDataConverter.convertSolution(gAnyData);
                break;
            }
            case TEMPLATE: {
                result = GetDataConverter.convertTemplate(gAnyData);
                break;
            }
            case ERROR_INFO: {
                result = GetDataConverter.convertErrorInfo(gAnyData);
                break;
            }
            case MODEL: {
                result = GetDataConverter.convertModel(gAnyData);
                break;
            }
            case EXECUTION_STATUS: {
                result = GetDataConverter.convertExecutionStatus(gAnyData);
                break;
            }
            default: {
                throw new RuntimeException("Failed create Any object unsupported data type");
            }
        }
        result.setModified(gAnyData.getModified());
        return result;
    }

    private static Any convertTemplate(GAnyData gAnyData) {
        GSolutionTemplate gSolutionTemplate = gAnyData.getTemplate();
        SolutionTemplate solutionTemplate = new SolutionTemplate();
        solutionTemplate.url = gAnyData.getUrl();
        solutionTemplate.appId = gSolutionTemplate.getAppId();
        solutionTemplate.caption = gSolutionTemplate.getCaption();
        solutionTemplate.id = gSolutionTemplate.getId();
        return new Any(gAnyData.getUrl(), (Object)solutionTemplate);
    }

    private static Any convertSolution(GAnyData gAnyData) {
        GSolutionApp gSolutionApp = gAnyData.getSolution();
        SolutionApp solutionApp = new SolutionApp();
        solutionApp.caption = gSolutionApp.getCaption();
        solutionApp.file = gSolutionApp.getFile();
        solutionApp.url = gAnyData.getUrl();
        solutionApp.id = gSolutionApp.getId();
        return new Any(gAnyData.getUrl(), (Object)solutionApp);
    }

    @Override
    public Any toValue(GAnyData gAnyData) {
        return GetDataConverter.convert(gAnyData);
    }

    @Override
    public Any toValue(GetDataResponse value) {
        return value.getDataCount() > 0 ? this.toValue(value.getData(0)) : null;
    }
}

